/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import com.gs.fw.common.mithra.generator.AbstractMithraGenerator;
import com.gs.fw.common.mithra.generator.CoreMithraGenerator;
import com.gs.fw.common.mithra.generator.MithraGeneratorImport;
import com.gs.fw.common.mithra.generator.MithraObjectTypeParser;
import com.gs.fw.common.mithra.generator.MithraXMLObjectTypeParser;
import java.io.FileNotFoundException;
import org.apache.tools.ant.BuildException;

public class MithraGenerator
extends AbstractMithraGenerator {
    private CoreMithraGenerator coreGenerator;

    public MithraGenerator() {
        this(new CoreMithraGenerator());
    }

    public MithraGenerator(CoreMithraGenerator gen) {
        super(gen);
        this.coreGenerator = gen;
    }

    public boolean isGenerateImported() {
        return this.coreGenerator.isGenerateImported();
    }

    public void setGenerateImported(boolean generateImported) {
        this.coreGenerator.setGenerateImported(generateImported);
    }

    public void setGenerateConcreteClasses(boolean generateConcreteClasses) {
        this.coreGenerator.setGenerateConcreteClasses(generateConcreteClasses);
    }

    public void setWarnAboutConcreteClasses(boolean warnAboutConreteClasses) {
        this.coreGenerator.setWarnAboutConcreteClasses(warnAboutConreteClasses);
    }

    public void setGenerateGscListMethod(boolean generateGscListMethod) {
        this.coreGenerator.setGenerateGscListMethod(generateGscListMethod);
    }

    @Deprecated
    public void setGenerateLegacyCaramel(boolean generateLegacyCaramel) {
        this.coreGenerator.setGenerateLegacyCaramel(generateLegacyCaramel);
    }

    public void setCodeFormat(String format) {
        this.coreGenerator.setCodeFormat(format);
    }

    public void execute() throws BuildException {
        this.coreGenerator.execute();
    }

    public void setGenerateFileHeaders(boolean generateFileHeaders) {
        this.coreGenerator.setGenerateFileHeaders(generateFileHeaders);
    }

    public void setMithraObjectTypeParser(MithraObjectTypeParser mithraObjectTypeParser) {
        this.coreGenerator.setMithraObjectTypeParser(mithraObjectTypeParser);
    }

    public void parseAndValidate() throws FileNotFoundException {
        this.coreGenerator.parseAndValidate();
    }

    public static void main(String[] args) {
        MithraGenerator gen = new MithraGenerator(){

            public void log(String s) {
                System.out.println(s);
            }

            public void log(String s, int i) {
                System.out.println(s);
            }
        };
        String root = "/home/moh/projects/reladomo/";
        MithraXMLObjectTypeParser parser = new MithraXMLObjectTypeParser(root + "reladomo/src/test/reladomo-xml/MithraClassList.xml");
        gen.setMithraObjectTypeParser(parser);
        gen.setGeneratedDir(root + "tmp/gen");
        gen.setNonGeneratedDir(root + "tmp/nogen");
        gen.setGenerateGscListMethod(true);
        gen.setCodeFormat("fast");
        gen.setDefaultFinalGetters(false);
        long startTime = System.currentTimeMillis();
        MithraGeneratorImport generatorImport = new MithraGeneratorImport();
        generatorImport.setDir(root + "reladomo/src/test/reladomo-xml/");
        generatorImport.setFilename("MithraClassListToImport.xml");
        gen.addConfiguredMithraImport(generatorImport);
        generatorImport = new MithraGeneratorImport();
        generatorImport.setDir(root + "reladomo/src/test/reladomo-xml/testmithraimport/");
        generatorImport.setFilename("MithraTestImportClassList.xml");
        gen.addConfiguredMithraImport(generatorImport);
        gen.execute();
        System.out.println("time: " + (System.currentTimeMillis() - startTime));
    }
}

