/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import com.gs.fw.common.mithra.generator.MithraGeneratorException;
import com.gs.fw.common.mithra.generator.filesystem.DirectoryFileProvider;
import com.gs.fw.common.mithra.generator.filesystem.FauxFileSystem;
import com.gs.fw.common.mithra.generator.filesystem.FileProvider;
import com.gs.fw.common.mithra.generator.filesystem.JarFileProvider;

public class MithraGeneratorImport {
    private String filename;
    private String dir;
    private String archive;
    private String[] excludeList;
    private FileProvider fileProvider;
    private FauxFileSystem fauxFileSystem;

    public void init() {
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setArchive(String archive) {
        this.archive = archive;
    }

    public String[] getExcludeList() {
        return this.excludeList;
    }

    public void setExcludeList(String excludeListString) {
        this.excludeList = excludeListString.split(",");
    }

    public FileProvider getFileProvider() {
        if (this.fileProvider == null) {
            if (this.archive != null) {
                this.fileProvider = new JarFileProvider(this.excludeList, this.archive, this.dir);
            } else if (this.dir != null) {
                this.fileProvider = new DirectoryFileProvider(this.fauxFileSystem, this.excludeList, this.dir);
            } else {
                throw new MithraGeneratorException("Cannot determine file provider to use - both archive and dir are not set.");
            }
        }
        return this.fileProvider;
    }

    public void setFauxFileSystem(FauxFileSystem fauxFileSystem) {
        this.fauxFileSystem = fauxFileSystem;
    }

    public FauxFileSystem getFauxFileSystem() {
        return this.fauxFileSystem;
    }
}

