/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import com.gs.fw.common.mithra.generator.Attribute;
import com.gs.fw.common.mithra.generator.CommonAttribute;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.metamodel.PropertyType;
import com.gs.fw.common.mithra.generator.metamodel.SourceAttributeType;
import com.gs.fw.common.mithra.generator.metamodel.TimePrecisionType;
import com.gs.fw.common.mithra.generator.type.JavaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceAttribute
extends Attribute {
    private JavaType type;
    private SourceAttributeType wrapped;

    public SourceAttribute(SourceAttributeType sourceAttributeType, MithraObjectTypeWrapper owner) {
        super(owner);
        this.wrapped = sourceAttributeType;
        this.type = JavaType.create(this.wrapped.getJavaType());
    }

    @Override
    public boolean isFinalGetter() {
        return this.wrapped.isFinalGetterSet() ? this.wrapped.isFinalGetter() : this.getOwner().isDefaultFinalGetters();
    }

    @Override
    public boolean isPrimaryKeyUsingSimulatedSequence() {
        return false;
    }

    public boolean isIntSourceAttribute() {
        return "Integer.TYPE".equals(this.type.getJavaTypeClass());
    }

    public boolean isStringSourceAttribute() {
        return "String.class".equals(this.type.getJavaTypeClass());
    }

    @Override
    public boolean isPoolable() {
        return this.isStringAttribute();
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isReadonly() {
        return false;
    }

    @Override
    public String getQuotedColumnName() {
        return "null";
    }

    @Override
    public boolean isMutablePrimaryKey() {
        return false;
    }

    @Override
    public JavaType getType() {
        return this.type;
    }

    public String getAttributeClass() {
        return this.getType().getJavaTypeClass();
    }

    @Override
    public boolean isSourceAttribute() {
        return true;
    }

    @Override
    public boolean isPrimaryKey() {
        return false;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    @Override
    public boolean mustTrim() {
        return false;
    }

    @Override
    public boolean hasMaxLength() {
        return false;
    }

    @Override
    public int getMaxLength() {
        return 0;
    }

    @Override
    public boolean hasModifyTimePrecisionOnSet() {
        return false;
    }

    @Override
    public TimePrecisionType getModifyTimePrecisionOnSet() {
        return null;
    }

    @Override
    public List getProperty() {
        return this.wrapped.getProperties();
    }

    @Override
    public boolean hasProperties() {
        return this.wrapped.getProperties() != null && !this.wrapped.getProperties().isEmpty();
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.hasProperties()) {
            List<PropertyType> propertyTypes = this.wrapped.getProperties();
            for (PropertyType property : propertyTypes) {
                properties.put(property.getKey(), property.getValue() == null ? "Boolean.TRUE" : property.getValue());
            }
        }
        return properties;
    }

    @Override
    public List validateAndUseMissingValuesFromSuperClass(CommonAttribute superClassAttribute) {
        ArrayList<String> errors = new ArrayList<String>();
        SourceAttribute superClassSourceAttribute = (SourceAttribute)superClassAttribute;
        if (!superClassSourceAttribute.getFinderAttributeType().equals(this.getFinderAttributeType())) {
            errors.add("java type for attribute '" + this.getName() + "' does not match java type for same attribute in superclass '" + superClassAttribute.getName());
        }
        return errors;
    }

    @Override
    public Attribute cloneForNewOwner(MithraObjectTypeWrapper newOwner) {
        return new SourceAttribute(this.wrapped, newOwner);
    }

    @Override
    public boolean isMapped() {
        return false;
    }
}

