/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import java.io.PrintWriter;

public class SourceFormatter {
    private static final FormatState NORMAL_STATE = new NormalState();
    private static final FormatState LONG_COMMENT_STATE = new LongCommentState();
    private static final FormatState DOUBLE_QUOTE_STATE = new QuoteState('\"');
    private static final FormatState SINGLE_QUOTE_STATE = new QuoteState('\'');
    private ProcessingState processingState = new ProcessingState();

    public SourceFormatter() {
        this.init();
    }

    public void init() {
        this.processingState.formatState = SourceFormatter.NORMAL_STATE;
        this.processingState.indent = 0;
        this.processingState.previousLineWasBlank = false;
    }

    public void formatLine(String line, PrintWriter writer) {
        this.processingState.setLine(line);
        this.processingState.pwriter = writer;
        this.processingState = this.processingState.formatState.formatPartialLine(this.processingState);
        while (!this.processingState.isDoneWithLine()) {
            this.processingState = this.processingState.formatState.formatPartialLine(this.processingState);
        }
    }

    private static class QuoteState
    implements FormatState {
        private char quoteChar;

        private QuoteState(char quoteChar) {
            this.quoteChar = quoteChar;
        }

        public ProcessingState formatPartialLine(ProcessingState processingState) {
            while (processingState.offset < processingState.end) {
                char c = processingState.line.charAt(processingState.offset);
                if (c == this.quoteChar) {
                    processingState.emitChar(c);
                    processingState.offset++;
                    processingState.emitEndOfLineIfDone();
                    processingState.formatState = NORMAL_STATE;
                    return processingState;
                }
                if (c == '\\') {
                    processingState.emitChar(c);
                    if (processingState.offset < processingState.end - 1) {
                        processingState.offset++;
                        processingState.emitChar(processingState.line.charAt(processingState.offset));
                    }
                } else {
                    processingState.emitChar(c);
                }
                processingState.offset++;
            }
            processingState.offset = processingState.end;
            processingState.emitEndOfLineIfNotBlank();
            processingState.formatState = NORMAL_STATE;
            return processingState;
        }
    }

    private static class LongCommentState
    implements FormatState {
        private LongCommentState() {
        }

        public ProcessingState formatPartialLine(ProcessingState processingState) {
            if (processingState.isDoneWithLine()) {
                processingState.emitBlankLine();
                return processingState;
            }
            int endComment = processingState.line.indexOf("*/", processingState.offset);
            if (endComment >= 0) {
                processingState.appendPartialLine(endComment + 2);
                processingState.offset = endComment + 2;
                processingState.emitEndOfLineIfDone();
                processingState.formatState = NORMAL_STATE;
                return processingState;
            }
            processingState.appendRemainingLineWithEndOfLine();
            return processingState;
        }
    }

    private static class NormalState
    implements FormatState {
        private NormalState() {
        }

        public ProcessingState formatPartialLine(ProcessingState processingState) {
            int lastNormalChar = 0;
            while (processingState.offset < processingState.end) {
                char c = processingState.line.charAt(processingState.offset);
                boolean emitWhite = false;
                while (Character.isWhitespace(c) && processingState.offset < processingState.end) {
                    emitWhite = true;
                    c = processingState.line.charAt(++processingState.offset);
                }
                if (emitWhite) {
                    processingState.emitWhite();
                    if (processingState.isDoneWithLine()) {
                        processingState.emitEndOfLineIfNotBlank();
                        return processingState;
                    }
                }
                switch (c) {
                    case '\"': {
                        processingState.emitChar(c);
                        processingState.offset++;
                        processingState.formatState = DOUBLE_QUOTE_STATE;
                        return processingState;
                    }
                    case '\'': {
                        processingState.emitChar(c);
                        processingState.offset++;
                        processingState.formatState = SINGLE_QUOTE_STATE;
                        return processingState;
                    }
                    case '{': {
                        processingState.emitEndOfLineIfNotBlank();
                        processingState.emitChar(c);
                        processingState.indent++;
                        processingState.emitEndOfLine();
                        break;
                    }
                    case '}': {
                        processingState.emitEndOfLineIfNotBlank();
                        processingState.indent--;
                        processingState.emitChar(c);
                        processingState.emitEndOfLine();
                        processingState.emitBlankLine();
                        break;
                    }
                    case '/': {
                        if (processingState.offset == processingState.end - 1) {
                            processingState.emitChar(c);
                            break;
                        }
                        char nextChar = processingState.line.charAt(processingState.offset + 1);
                        if (nextChar == '*') {
                            processingState.emitChar('/');
                            processingState.emitChar('*');
                            processingState.offset += 2;
                            processingState.formatState = LONG_COMMENT_STATE;
                            return processingState;
                        }
                        if (nextChar == '/') {
                            processingState.appendRemainingLineWithEndOfLine();
                            return processingState;
                        }
                        processingState.emitChar(c);
                        break;
                    }
                    default: {
                        processingState.emitChar(c);
                        lastNormalChar = c;
                    }
                }
                processingState.offset++;
            }
            if (lastNormalChar == 44 || lastNormalChar == 40 || lastNormalChar == 58) {
                processingState.tempIndent = true;
            }
            processingState.emitEndOfLineIfNotBlank();
            return processingState;
        }
    }

    private static interface FormatState {
        public ProcessingState formatPartialLine(ProcessingState var1);
    }

    private static class ProcessingState {
        private String line;
        private int offset;
        private int end;
        private int indent;
        private PrintWriter pwriter;
        private boolean currentLineIsBlank = true;
        private FormatState formatState = SourceFormatter.access$800();
        private boolean previousLineWasBlank;
        public boolean tempIndent;

        private ProcessingState() {
        }

        public void setLine(String line) {
            this.line = line;
            this.offset = 0;
            this.end = line.length();
            while (!this.isDoneWithLine() && Character.isWhitespace(this.line.charAt(this.end - 1))) {
                --this.end;
            }
            while (!this.isDoneWithLine() && Character.isWhitespace(this.line.charAt(this.offset))) {
                ++this.offset;
            }
        }

        private void indentLine() {
            for (int i = 0; i < this.indent; ++i) {
                this.pwriter.append('\t');
            }
            if (this.tempIndent) {
                this.tempIndent = false;
                this.pwriter.append('\t');
            }
        }

        public void emitBlankLine() {
            this.previousLineWasBlank = true;
        }

        public void emitEndOfLine() {
            this.previousLineWasBlank = this.currentLineIsBlank;
            this.pwriter.write("\n");
            this.currentLineIsBlank = true;
        }

        public boolean isDoneWithLine() {
            return this.offset == this.end;
        }

        public void appendRemainingLineWithEndOfLine() {
            while (!this.isDoneWithLine() && Character.isWhitespace(this.line.charAt(this.offset))) {
                ++this.offset;
            }
            if (this.offset == this.end) {
                if (this.currentLineIsBlank) {
                    this.previousLineWasBlank = true;
                } else {
                    this.emitEndOfLine();
                }
            } else {
                this.indentLineIfBlank();
                this.pwriter.append(this.line, this.offset, this.end);
                this.emitEndOfLine();
            }
            this.offset = this.end;
        }

        public void appendPartialLine(int appendEnd) {
            while (!this.isDoneWithLine() && Character.isWhitespace(this.line.charAt(this.offset))) {
                ++this.offset;
            }
            if (this.offset != this.end) {
                this.indentLineIfBlank();
                this.pwriter.append(this.line, this.offset, appendEnd);
                this.offset = appendEnd;
            }
        }

        public void emitEndOfLineIfNotBlank() {
            if (!this.currentLineIsBlank) {
                this.emitEndOfLine();
            }
        }

        public void emitWhite() {
            if (!this.currentLineIsBlank) {
                this.pwriter.append(' ');
            }
        }

        public void emitChar(char c) {
            if (this.currentLineIsBlank && this.previousLineWasBlank && c != '}' && c != '}' && !this.line.regionMatches(false, this.offset, "else", 0, "else".length())) {
                this.emitEndOfLine();
            }
            this.indentLineIfBlank();
            this.pwriter.write(c);
            this.currentLineIsBlank = false;
        }

        public void indentLineIfBlank() {
            if (this.currentLineIsBlank) {
                this.indentLine();
                this.currentLineIsBlank = false;
            }
        }

        public void emitEndOfLineIfDone() {
            if (this.isDoneWithLine()) {
                this.emitEndOfLineIfNotBlank();
            }
        }
    }
}

