/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.computedattribute;

import com.gs.fw.common.mithra.generator.AbstractAttribute;
import com.gs.fw.common.mithra.generator.Attribute;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.computedattribute.Expression;
import com.gs.fw.common.mithra.generator.computedattribute.type.Type;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeExpression
extends Expression {
    private String attributeName;
    private AbstractAttribute singleColumnAttribute;

    public AttributeExpression(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public void addAttributeList(Set<String> result) {
        result.add(this.attributeName);
    }

    @Override
    public void resolveAttributes(MithraObjectTypeWrapper wrapper, List<String> errors) {
        Attribute attributeByName = wrapper.getAttributeByName(this.attributeName);
        if (attributeByName != null) {
            this.singleColumnAttribute = attributeByName;
        } else {
            errors.add("Could not find attribute " + this.attributeName + " in object " + wrapper.getClassName());
        }
    }

    @Override
    public Type getType() {
        if (this.singleColumnAttribute != null) {
            return this.singleColumnAttribute.getType().asComputedAttributeType();
        }
        return null;
    }
}

