/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.computedattribute;

import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.computedattribute.Expression;
import com.gs.fw.common.mithra.generator.computedattribute.ParseException;
import com.gs.fw.common.mithra.generator.computedattribute.type.BooleanType;
import com.gs.fw.common.mithra.generator.computedattribute.type.NumberType;
import com.gs.fw.common.mithra.generator.computedattribute.type.StringType;
import com.gs.fw.common.mithra.generator.computedattribute.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseFragment {
    private boolean keyState = true;
    private Type keyType;
    private Type valueType;
    private List keys = new ArrayList();
    private boolean isDefault;
    private Expression value;

    public CaseFragment(Type keyType) {
        this.keyType = keyType;
    }

    public void endKey() {
        this.keyState = false;
    }

    public void addNullKey() {
        this.checkKeyState();
        this.keys.add(null);
    }

    private void checkKeyState() {
        if (this.isDefault) {
            throw new ParseException("the 'default' case must appear on its own");
        }
        if (!this.keyState) {
            throw new ParseException("was expecting a value and got a selector key instead!");
        }
    }

    public void addStringKey(String constant) {
        this.checkKeyState();
        this.checkKeyType(StringType.class);
        this.keys.add(constant);
    }

    private void checkKeyType(Class typeClass) {
        if (!typeClass.equals(this.keyType.getClass())) {
            throw new ParseException("was expecting " + this.keyType.toString() + " type, but got " + typeClass.getName().toString());
        }
    }

    public void addNumberKey(double nval) {
        this.checkKeyState();
        if (!(this.keyType instanceof NumberType)) {
            throw new ParseException("was expecting a " + this.keyType.toString() + " not a number " + nval);
        }
        this.keys.add(((NumberType)this.keyType).convertFromDouble(nval));
    }

    public void addBooleanKey(boolean key) {
        this.checkKeyState();
        this.checkKeyType(BooleanType.class);
        if (!this.keys.isEmpty()) {
            throw new ParseException("it's meaningless to combine multiple boolean case selectors");
        }
        this.keys.add(key);
    }

    public void addDefaultKey() {
        this.isDefault = true;
    }

    public void setValue(Expression param) {
        if (this.keyState) {
            throw new ParseException("was expecting a value not a key");
        }
        if (this.valueType == null) {
            this.valueType = param.getType();
        } else if (!this.valueType.isCompatibleWith(param.getType())) {
            throw new ParseException("can't mix value types " + this.valueType.toString() + " with " + param.getType());
        }
        if (this.value != null) {
            throw new ParseException("expecting only one value");
        }
        this.value = param;
    }

    public void addAttributeList(Set<String> result) {
        this.value.addAttributeList(result);
    }

    public void resolveAttributes(MithraObjectTypeWrapper wrapper, List<String> errors) {
        this.value.resolveAttributes(wrapper, errors);
    }

    public Type getValueType() {
        return this.value.getType();
    }
}

