/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.computedattribute;

import com.gs.fw.common.mithra.generator.computedattribute.CaseExpression;
import com.gs.fw.common.mithra.generator.computedattribute.CaseSelectorBeginParserState;
import com.gs.fw.common.mithra.generator.computedattribute.ComputedAttributeParser;
import com.gs.fw.common.mithra.generator.computedattribute.ComputedAttributeParserState;
import com.gs.fw.common.mithra.generator.computedattribute.Expression;
import com.gs.fw.common.mithra.generator.computedattribute.ExpressionBeginState;
import com.gs.fw.common.mithra.generator.computedattribute.FunctionBeginExpressionState;
import com.gs.fw.common.mithra.generator.computedattribute.FunctionExpression;
import com.gs.fw.common.mithra.generator.computedattribute.ParseException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEndState
extends ComputedAttributeParserState {
    public ExpressionEndState(ComputedAttributeParser computedAttributeParser) {
        super(computedAttributeParser);
    }

    @Override
    public ComputedAttributeParserState parse(StreamTokenizer st) throws IOException, ParseException {
        ComputedAttributeParserState nextState = null;
        block8: while (nextState == null && st.ttype != -1) {
            int nextToken = st.nextToken();
            if (nextToken == 10 || nextToken == -1) continue;
            ArrayList<Expression> stack = this.getParser().getStateStack();
            switch (nextToken) {
                case 46: {
                    Expression expression = stack.remove(stack.size() - 1);
                    stack.add(new FunctionExpression(expression));
                    nextState = new FunctionBeginExpressionState(this.getParser());
                    continue block8;
                }
                case 44: {
                    this.addParameterToFunction(st, stack);
                    nextState = new ExpressionBeginState(this.getParser());
                    continue block8;
                }
                case 59: {
                    this.endCaseValue(st, stack);
                    nextState = new CaseSelectorBeginParserState(this.getParser());
                    continue block8;
                }
                case 41: {
                    this.endFunctionOrCase(st, stack);
                    continue block8;
                }
                case -2: {
                    throw new ParseException("unexpected number " + st.nval + " in expression " + this.getParser().getFormula() + " in " + this.getParser().getDiagnosticMessage());
                }
                case -3: {
                    throw new ParseException("unexpected word " + st.sval + " in expression " + this.getParser().getFormula() + " in " + this.getParser().getDiagnosticMessage());
                }
            }
            char ch = (char)st.ttype;
            throw this.createUnexpectedCharacterException(ch, ",;).");
        }
        return nextState;
    }

    private void endCaseValue(StreamTokenizer st, ArrayList<Expression> stack) {
        Expression lastExpression = stack.remove(stack.size() - 1);
        Expression caseExpression = stack.get(stack.size() - 1);
        if (!(caseExpression instanceof CaseExpression)) {
            throw new ParseException("expecting ';' to appear only inside a case statement");
        }
        ((CaseExpression)caseExpression).setValue(lastExpression);
    }

    private void endFunctionOrCase(StreamTokenizer st, ArrayList<Expression> stack) {
        FunctionExpression func;
        Expression lastExpression = stack.get(stack.size() - 1);
        FunctionExpression functionToFinish = null;
        if (lastExpression instanceof FunctionExpression && !(func = (FunctionExpression)lastExpression).isFinished()) {
            functionToFinish = func;
        }
        if (functionToFinish == null) {
            Expression param = stack.remove(stack.size() - 1);
            Expression caseOrFunction = stack.get(stack.size() - 1);
            if (caseOrFunction instanceof FunctionExpression) {
                functionToFinish = (FunctionExpression)caseOrFunction;
                functionToFinish.addParameter(param);
            } else if (caseOrFunction instanceof CaseExpression) {
                ((CaseExpression)caseOrFunction).setValue(param);
                ((CaseExpression)caseOrFunction).markFinished();
            } else {
                throw new ParseException("the closing parenthesis is not parsable as a function or case statement end");
            }
        }
        if (functionToFinish != null) {
            functionToFinish.markFinished();
        }
    }

    private void addParameterToFunction(StreamTokenizer st, ArrayList<Expression> stack) throws ParseException {
        Expression parameter = stack.remove(stack.size() - 1);
        Expression function = stack.get(stack.size() - 1);
        if (!(function instanceof FunctionExpression)) {
            throw new ParseException("The comma in the expression " + this.getParser().getFormula() + " was expecting a function to precede it, but instead got " + function.toString());
        }
        ((FunctionExpression)function).addParameter(parameter);
    }
}

