/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.databasetype;

import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import java.util.HashMap;
import java.util.Map;

public class H2DatabaseType
implements CommonDatabaseType {
    private static final H2DatabaseType instance = new H2DatabaseType();
    private static final Map<String, String> sqlToJavaTypes = new HashMap<String, String>();

    protected H2DatabaseType() {
    }

    public static H2DatabaseType getInstance() {
        return instance;
    }

    public String getSqlDataTypeForNullableBoolean() {
        return "boolean";
    }

    public String getSqlDataTypeForBoolean() {
        return "boolean";
    }

    public String getSqlDataTypeForTimestamp() {
        return "datetime";
    }

    public String getSqlDataTypeForTime() {
        return "time";
    }

    public String getSqlDataTypeForTinyInt() {
        return "tinyint";
    }

    public String getSqlDataTypeForVarBinary() {
        return "binary";
    }

    public String getSqlDataTypeForByte() {
        return "tinyint";
    }

    public String getSqlDataTypeForChar() {
        return "varchar(1)";
    }

    public String getSqlDataTypeForDateTime() {
        return "timestamp";
    }

    public String getSqlDataTypeForDouble() {
        return "double";
    }

    public String getSqlDataTypeForFloat() {
        return "double";
    }

    public String getSqlDataTypeForInt() {
        return "int";
    }

    public String getSqlDataTypeForLong() {
        return "bigint";
    }

    public String getSqlDataTypeForShortJava() {
        return "smallint";
    }

    public String getSqlDataTypeForString() {
        return "varchar";
    }

    public String getSqlDataTypeForBigDecimal() {
        return "decimal";
    }

    public String getJavaTypeFromSql(String sql, Integer precision, Integer decimal) {
        return sqlToJavaTypes.get(sql);
    }

    static {
        sqlToJavaTypes.put("integer", "int");
        sqlToJavaTypes.put("smallint", "short");
        sqlToJavaTypes.put("tinyint", "byte");
        sqlToJavaTypes.put("float", "float");
        sqlToJavaTypes.put("double precision", "double");
        sqlToJavaTypes.put("double precis", "double");
        sqlToJavaTypes.put("double", "double");
        sqlToJavaTypes.put("smallmoney", "not implemented");
        sqlToJavaTypes.put("money", "not implemented");
        sqlToJavaTypes.put("char", "char");
        sqlToJavaTypes.put("varchar", "String");
        sqlToJavaTypes.put("text", "String");
        sqlToJavaTypes.put("image", "byte[]");
        sqlToJavaTypes.put("datetime", "Timestamp");
        sqlToJavaTypes.put("smalldatetime", "Timestamp");
        sqlToJavaTypes.put("timestamp", "Timestamp");
        sqlToJavaTypes.put("bit", "boolean");
        sqlToJavaTypes.put("binary", "not implemented");
        sqlToJavaTypes.put("varbinary", "not implemented");
        sqlToJavaTypes.put("decimal", "BigDecimal");
        sqlToJavaTypes.put("real", "float");
        sqlToJavaTypes.put("date", "Timestamp");
        sqlToJavaTypes.put("time", "Time");
    }
}

