/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.databasetype;

import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import java.util.HashMap;
import java.util.Map;

public class Udb82DatabaseType
implements CommonDatabaseType {
    private static final Udb82DatabaseType instance = new Udb82DatabaseType();
    private static final Map<String, String> sqlToJavaTypes = new HashMap<String, String>();

    protected Udb82DatabaseType() {
    }

    public static Udb82DatabaseType getInstance() {
        return instance;
    }

    public String getSqlDataTypeForNullableBoolean() {
        return "smallint";
    }

    public String getSqlDataTypeForBoolean() {
        return "smallint";
    }

    public String getSqlDataTypeForTimestamp() {
        return "timestamp";
    }

    public String getSqlDataTypeForTime() {
        return "time";
    }

    public String getSqlDataTypeForTinyInt() {
        return "smallint";
    }

    public String getSqlDataTypeForVarBinary() {
        return "blob";
    }

    public String getSqlDataTypeForByte() {
        return "smallint";
    }

    public String getSqlDataTypeForChar() {
        return "character";
    }

    public String getSqlDataTypeForDateTime() {
        return "date";
    }

    public String getSqlDataTypeForDouble() {
        return "double";
    }

    public String getSqlDataTypeForFloat() {
        return "real";
    }

    public String getSqlDataTypeForInt() {
        return "integer";
    }

    public String getSqlDataTypeForLong() {
        return "bigint";
    }

    public String getSqlDataTypeForShortJava() {
        return "smallint";
    }

    public String getSqlDataTypeForString() {
        return "varchar";
    }

    public String getSqlDataTypeForBigDecimal() {
        return "decimal";
    }

    public String getJavaTypeFromSql(String sql, Integer precision, Integer decimal) {
        return sqlToJavaTypes.get(sql);
    }

    static {
        sqlToJavaTypes.put("blob", "not implemented");
        sqlToJavaTypes.put("bigint", "long");
        sqlToJavaTypes.put("integer", "int");
        sqlToJavaTypes.put("smallint", "short");
        sqlToJavaTypes.put("tinyint", "short");
        sqlToJavaTypes.put("double", "double");
        sqlToJavaTypes.put("character", "String");
        sqlToJavaTypes.put("char", "String");
        sqlToJavaTypes.put("varchar", "String");
        sqlToJavaTypes.put("blob", "String");
        sqlToJavaTypes.put("clob", "String");
        sqlToJavaTypes.put("date", "Timestamp");
        sqlToJavaTypes.put("time", "Time");
        sqlToJavaTypes.put("timestamp", "Timestamp");
        sqlToJavaTypes.put("bit", "byte");
        sqlToJavaTypes.put("decimal", "BigDecimal");
        sqlToJavaTypes.put("real", "float");
    }
}

