/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.filesystem;

import com.gs.fw.common.mithra.generator.MithraGeneratorException;
import com.gs.fw.common.mithra.generator.filesystem.AbstractFileProvider;
import com.gs.fw.common.mithra.generator.filesystem.FileInputStreamWithSize;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarFileProvider
extends AbstractFileProvider {
    private String dir;
    private JarFile jarFile;

    public JarFileProvider(String[] excludeList, String archive, String dir) {
        super(excludeList);
        try {
            this.jarFile = new JarFile(archive);
            this.dir = dir;
        }
        catch (IOException e) {
            throw new MithraGeneratorException("unable to find mithra import archive '" + archive + "'", e);
        }
    }

    public FileInputStreamWithSize getFileInputStream(String fileName) throws FileNotFoundException {
        String fullFileName = this.getDirectoryPrefix() + fileName;
        try {
            ZipEntry entry = this.jarFile.getEntry(fullFileName);
            if (entry == null) {
                throw new MithraGeneratorException("unable to find '" + fullFileName + "' in import archive file '" + this.jarFile.getName() + "'");
            }
            return new FileInputStreamWithSize(this.jarFile.getInputStream(entry), entry.getSize());
        }
        catch (IOException e) {
            this.close();
            throw new MithraGeneratorException("unexpected error while reading '" + fullFileName + "' from import archive '" + this.jarFile.getName() + "'", e);
        }
    }

    private String getDirectoryPrefix() {
        return this.dir == null ? "" : this.dir + "/";
    }

    public void close() {
        try {
            this.jarFile.close();
        }
        catch (IOException e) {
            throw new MithraGeneratorException("can't close archive jar file '" + this.jarFile.getName() + "'", e);
        }
    }

    public String getSourceName() {
        return this.jarFile.getName();
    }
}

