/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.mapper;

import com.gs.fw.common.mithra.generator.RelationshipAttribute;
import com.gs.fw.common.mithra.generator.mapper.JoinNode;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryConverter {
    private RelationshipAttribute relationshipAttribute;
    private JoinNode treeRootWithoutSource;
    private JoinNode sourceNode;
    private List<JoinNode> danglingNodesAtEnd;

    public QueryConverter(RelationshipAttribute relationshipAttribute, JoinNode sourceNode, JoinNode treeRootWithoutSource, List<JoinNode> danglingNodesAtEnd) {
        this.relationshipAttribute = relationshipAttribute;
        this.sourceNode = sourceNode;
        this.treeRootWithoutSource = treeRootWithoutSource;
        this.danglingNodesAtEnd = danglingNodesAtEnd;
    }

    public boolean hasCondition() {
        return !this.sourceNode.getFurtherJoins().isEmpty() || this.sourceNode.getParentJoin().hasRightFilters();
    }

    public String getCondition() {
        return "FIXME";
    }

    public String getOperation() {
        String opStr = this.constructOperationWithoutMapper();
        if (this.hasMapperFragment()) {
            opStr = "new MappedOperation(" + this.relationshipAttribute.getFromObject().getFinderClassName() + ".zGet" + this.relationshipAttribute.getMapperFragmentName() + "MapperFragment(" + this.getMapperFragmentParameterVariables() + "), " + opStr + ")";
        }
        return opStr;
    }

    public String getMapperFragmentParameterVariables() {
        if (this.relationshipAttribute.hasParameters()) {
            return this.treeRootWithoutSource.getUsedParameterVariables(this.relationshipAttribute);
        }
        return "";
    }

    private String constructOperationWithoutMapper() {
        String operation = this.sourceNode.getParentJoin().constructOperationFromRight(this.hasDangleMapper());
        if (this.hasDangleMapper()) {
            operation = operation + ".and(new MappedOperation(" + this.relationshipAttribute.getFromObject().getFinderClassName() + ".zGet" + this.relationshipAttribute.getMapperPartialName() + "DangleMapper(" + this.relationshipAttribute.getParameterVariables() + "), " + this.danglingNodesAtEnd.get(0).getParentJoin().getRight().getFinderClassName() + ".all()))";
        }
        return operation;
    }

    public boolean hasMapperFragment() {
        return !this.treeRootWithoutSource.isEndNode();
    }

    public String constructMapperFragment() {
        return this.treeRootWithoutSource.constructReverseMapperCommon(this.relationshipAttribute.getName(), false, null);
    }

    public boolean hasMapperFragmentParameters() {
        return this.getMapperFragmentParameterVariables().length() > 0;
    }

    public String getMapperFragmentParameters() {
        if (this.relationshipAttribute.hasParameters()) {
            return this.treeRootWithoutSource.getUsedParameters(this.relationshipAttribute);
        }
        return "";
    }

    public boolean hasDangleMapper() {
        return !this.danglingNodesAtEnd.isEmpty();
    }

    public String constructDangleMapper() {
        return this.danglingNodesAtEnd.get(0).getParentJoin().constructMapper("dangleMapper") + "\n" + "return dangleMapper;";
    }

    public boolean isExtractorBasedMultiEquality() {
        return this.sourceNode.getParentJoin().isExtractorBasedMultiEquality(this.hasDangleMapper());
    }

    public String getRelationshipMultiExtractorConstructor() {
        return this.sourceNode.getParentJoin().getRelationshipMultiExtractorConstructor();
    }

    public String getFindByUniqueLookupParameters() {
        return this.sourceNode.getParentJoin().getFindByUniqueLookupParameters();
    }
}

