/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.metamodel;

import com.gs.fw.common.mithra.generator.metamodel.EnumerationAttributeType;
import com.gs.fw.common.mithra.generator.metamodel.EnumerationMappingType;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorMarshaller;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorUnmarshaller;
import com.gs.fw.common.mithra.generator.metamodel.TimePrecisionType;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumerationAttributeTypeAbstract
implements Serializable {
    private String name;
    private String type;
    private String persistenceType;
    private String columnName;
    private boolean nullable = true;
    private boolean _isNullableSet;
    private String defaultIfNull;
    private boolean readonly = false;
    private boolean _isReadonlySet;
    private int maxLength;
    private boolean _isMaxLengthSet;
    private TimePrecisionType modifyTimePrecisionOnSet = new TimePrecisionType().with("millisecond", (EnumerationAttributeType)this);
    private boolean _isModifyTimePrecisionOnSetSet;
    private List<EnumerationMappingType> mappings = MithraGeneratorUnmarshaller.emptyList();
    private Object _parent;

    public Object parent() {
        return this._parent;
    }

    public void _setParent(Object parent) {
        this._parent = parent;
    }

    public void parse(MithraGeneratorUnmarshaller unmarshaller, String typeName) throws XMLStreamException {
        this.parseAttributes(unmarshaller);
        this.parseElements(unmarshaller, typeName);
    }

    protected void initListElements(MithraGeneratorUnmarshaller unmarshaller) {
        this.mappings = unmarshaller.newList();
    }

    protected void parseElements(MithraGeneratorUnmarshaller unmarshaller, String typeName) throws XMLStreamException {
        this.initListElements(unmarshaller);
        int eventType = unmarshaller.getNextStartOrEnd();
        if (!unmarshaller.isAtEnd(eventType, typeName)) {
            XMLStreamReader xmlStreamReader = unmarshaller.getXmlStreamReader();
            int currentElementState = Integer.MAX_VALUE;
            int state = 0;
            while (eventType == 1) {
                String elementName = xmlStreamReader.getLocalName();
                currentElementState = this.getState(elementName);
                if (state <= currentElementState) {
                    if (state < 0) {
                        unmarshaller.throwException("unexpected element in EnumerationAttributeType: " + elementName);
                    }
                } else {
                    unmarshaller.throwException("element out of order " + elementName + " in type EnumerationAttributeType");
                }
                this.parseElement(unmarshaller, state, elementName);
                state = currentElementState;
                eventType = unmarshaller.getNextStartOrEnd();
            }
            unmarshaller.expectEnd(eventType, typeName);
            this.checkListMinOccurs(unmarshaller);
        }
    }

    protected void checkListMinOccurs(MithraGeneratorUnmarshaller unmarshaller) {
    }

    protected int getState(String elementName) throws XMLStreamException {
        if (elementName.equals("Mapping")) {
            return 1;
        }
        return -1;
    }

    protected void parseElement(MithraGeneratorUnmarshaller unmarshaller, int state, String elementName) throws XMLStreamException {
        if (elementName.equals("Mapping")) {
            EnumerationMappingType _mapping = new EnumerationMappingType();
            _mapping.parse(unmarshaller, "Mapping");
            _mapping._setParent(this);
            this.getMappings().add(_mapping);
        }
    }

    protected void parseAttributes(MithraGeneratorUnmarshaller unmarshaller) throws XMLStreamException {
        XMLStreamReader xmlStreamReader = unmarshaller.getXmlStreamReader();
        int attributes = xmlStreamReader.getAttributeCount();
        for (int i = 0; i < attributes; ++i) {
            String attributeValue;
            String attributeName = xmlStreamReader.getAttributeName(i).getLocalPart();
            if (this.parseAttribute(unmarshaller, attributeName, attributeValue = xmlStreamReader.getAttributeValue(i))) continue;
            unmarshaller.unknownAttribute(attributeName, attributeValue);
        }
        this.checkMandatoryAttributes(unmarshaller);
    }

    protected boolean parseAttribute(MithraGeneratorUnmarshaller unmarshaller, String attributeName, String attributeValue) throws XMLStreamException {
        if (attributeName.equals("name")) {
            this.setName(unmarshaller.toToken("name", attributeValue));
            return true;
        }
        if (attributeName.equals("type")) {
            this.setType(unmarshaller.toToken("type", attributeValue));
            return true;
        }
        if (attributeName.equals("persistenceType")) {
            this.setPersistenceType(unmarshaller.toToken("persistenceType", attributeValue));
            return true;
        }
        if (attributeName.equals("columnName")) {
            this.setColumnName(unmarshaller.toToken("columnName", attributeValue));
            return true;
        }
        if (attributeName.equals("nullable")) {
            this.setNullable(unmarshaller.parseBoolean("nullable", attributeValue));
            return true;
        }
        if (attributeName.equals("defaultIfNull")) {
            this.setDefaultIfNull(unmarshaller.toToken("defaultIfNull", attributeValue));
            return true;
        }
        if (attributeName.equals("readonly")) {
            this.setReadonly(unmarshaller.parseBoolean("readonly", attributeValue));
            return true;
        }
        if (attributeName.equals("maxLength")) {
            this.setMaxLength(unmarshaller.parseInt("maxLength", attributeValue));
            return true;
        }
        if (attributeName.equals("modifyTimePrecisionOnSet")) {
            TimePrecisionType _modifyTimePrecisionOnSet = new TimePrecisionType();
            _modifyTimePrecisionOnSet.parse("modifyTimePrecisionOnSet", attributeValue, unmarshaller);
            _modifyTimePrecisionOnSet._setParent(this);
            this.setModifyTimePrecisionOnSet(_modifyTimePrecisionOnSet);
            return true;
        }
        return false;
    }

    protected void checkMandatoryAttributes(MithraGeneratorUnmarshaller unmarshaller) {
        if (!this.isNameSet()) {
            unmarshaller.throwException("Attribute 'name' is not set in element '" + this.getClass().getName() + "'");
        }
        if (!this.isTypeSet()) {
            unmarshaller.throwException("Attribute 'type' is not set in element '" + this.getClass().getName() + "'");
        }
        if (!this.isPersistenceTypeSet()) {
            unmarshaller.throwException("Attribute 'persistenceType' is not set in element '" + this.getClass().getName() + "'");
        }
        if (!this.isColumnNameSet()) {
            unmarshaller.throwException("Attribute 'columnName' is not set in element '" + this.getClass().getName() + "'");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNameSet() {
        return this.name != null;
    }

    public void unsetName() {
        this.name = null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isTypeSet() {
        return this.type != null;
    }

    public void unsetType() {
        this.type = null;
    }

    public String getPersistenceType() {
        return this.persistenceType;
    }

    public void setPersistenceType(String persistenceType) {
        this.persistenceType = persistenceType;
    }

    public boolean isPersistenceTypeSet() {
        return this.persistenceType != null;
    }

    public void unsetPersistenceType() {
        this.persistenceType = null;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public boolean isColumnNameSet() {
        return this.columnName != null;
    }

    public void unsetColumnName() {
        this.columnName = null;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
        this._isNullableSet = true;
    }

    public boolean isNullableSet() {
        return this._isNullableSet;
    }

    public void unsetNullable() {
        this._isNullableSet = false;
        this.nullable = true;
    }

    public String getDefaultIfNull() {
        return this.defaultIfNull;
    }

    public void setDefaultIfNull(String defaultIfNull) {
        this.defaultIfNull = defaultIfNull;
    }

    public boolean isDefaultIfNullSet() {
        return this.defaultIfNull != null;
    }

    public void unsetDefaultIfNull() {
        this.defaultIfNull = null;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this._isReadonlySet = true;
    }

    public boolean isReadonlySet() {
        return this._isReadonlySet;
    }

    public void unsetReadonly() {
        this._isReadonlySet = false;
        this.readonly = false;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        this._isMaxLengthSet = true;
    }

    public boolean isMaxLengthSet() {
        return this._isMaxLengthSet;
    }

    public void unsetMaxLength() {
        this._isMaxLengthSet = false;
        this.maxLength = 0;
    }

    public TimePrecisionType getModifyTimePrecisionOnSet() {
        return this.modifyTimePrecisionOnSet;
    }

    public void setModifyTimePrecisionOnSet(TimePrecisionType modifyTimePrecisionOnSet) {
        this.modifyTimePrecisionOnSet = modifyTimePrecisionOnSet;
        this._isModifyTimePrecisionOnSetSet = true;
    }

    public boolean isModifyTimePrecisionOnSetSet() {
        return this._isModifyTimePrecisionOnSetSet;
    }

    public void unsetModifyTimePrecisionOnSet() {
        this._isModifyTimePrecisionOnSetSet = false;
        this.modifyTimePrecisionOnSet = new TimePrecisionType().with("millisecond", (EnumerationAttributeType)this);
    }

    public List<EnumerationMappingType> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<EnumerationMappingType> mappings) {
        this.mappings = mappings;
    }

    public boolean isMappingsSet() {
        return this.mappings != null && this.mappings.size() > 0;
    }

    protected void marshallAttributes(MithraGeneratorMarshaller marshaller) throws IOException {
        if (this.isNameSet()) {
            marshaller.writeAttribute("name", this.name);
        }
        if (this.isTypeSet()) {
            marshaller.writeAttribute("type", this.type);
        }
        if (this.isPersistenceTypeSet()) {
            marshaller.writeAttribute("persistenceType", this.persistenceType);
        }
        if (this.isColumnNameSet()) {
            marshaller.writeAttribute("columnName", this.columnName);
        }
        if (this.isNullableSet()) {
            marshaller.writeAttribute("nullable", this.nullable);
        }
        if (this.isDefaultIfNullSet()) {
            marshaller.writeAttribute("defaultIfNull", this.defaultIfNull);
        }
        if (this.isReadonlySet()) {
            marshaller.writeAttribute("readonly", this.readonly);
        }
        if (this.isMaxLengthSet()) {
            marshaller.writeAttribute("maxLength", this.maxLength);
        }
        if (this.isModifyTimePrecisionOnSetSet()) {
            this.modifyTimePrecisionOnSet.toXmlAsAttribute(marshaller, "modifyTimePrecisionOnSet");
        }
    }

    protected void marshallContent(MithraGeneratorMarshaller marshaller) throws IOException {
    }

    protected void marshallElements(MithraGeneratorMarshaller marshaller) throws IOException {
        if (this.isMappingsSet()) {
            for (EnumerationMappingType mapping : this.mappings) {
                mapping.toXml(marshaller, "Mapping");
            }
        }
    }

    public void toXml(MithraGeneratorMarshaller marshaller, String tagName) throws IOException {
        marshaller.writeStartTag(tagName);
        this.marshallAttributes(marshaller);
        this.marshallContent(marshaller);
        this.marshallElements(marshaller);
        marshaller.writeEndTag(tagName);
    }
}

