/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.metamodel;

import com.gs.fw.common.mithra.generator.metamodel.EnumerationMemberType;
import com.gs.fw.common.mithra.generator.metamodel.MithraBaseObjectType;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorMarshaller;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorUnmarshaller;
import java.io.IOException;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MithraEnumerationTypeAbstract
extends MithraBaseObjectType {
    private List<EnumerationMemberType> members = MithraGeneratorUnmarshaller.emptyList();
    private Object _parent;

    @Override
    public Object parent() {
        return this._parent;
    }

    @Override
    public void _setParent(Object parent) {
        this._parent = parent;
    }

    @Override
    public void parse(MithraGeneratorUnmarshaller unmarshaller, String typeName) throws XMLStreamException {
        this.parseAttributes(unmarshaller);
        this.parseElements(unmarshaller, typeName);
    }

    @Override
    protected void initListElements(MithraGeneratorUnmarshaller unmarshaller) {
        super.initListElements(unmarshaller);
        this.members = unmarshaller.newList();
    }

    @Override
    protected void parseElements(MithraGeneratorUnmarshaller unmarshaller, String typeName) throws XMLStreamException {
        this.initListElements(unmarshaller);
        int eventType = unmarshaller.getNextStartOrEnd();
        if (!unmarshaller.isAtEnd(eventType, typeName)) {
            XMLStreamReader xmlStreamReader = unmarshaller.getXmlStreamReader();
            int currentElementState = Integer.MAX_VALUE;
            int state = 0;
            while (eventType == 1) {
                String elementName = xmlStreamReader.getLocalName();
                currentElementState = this.getState(elementName);
                if (state <= currentElementState) {
                    if (state < 0) {
                        unmarshaller.throwException("unexpected element in MithraEnumerationType: " + elementName);
                    }
                } else {
                    unmarshaller.throwException("element out of order " + elementName + " in type MithraEnumerationType");
                }
                this.parseElement(unmarshaller, state, elementName);
                state = currentElementState;
                eventType = unmarshaller.getNextStartOrEnd();
            }
            if (state < 3) {
                unmarshaller.throwException("expecting at least one element of type Member in MithraEnumerationType");
            }
            unmarshaller.expectEnd(eventType, typeName);
            this.checkListMinOccurs(unmarshaller);
        }
    }

    @Override
    protected void checkListMinOccurs(MithraGeneratorUnmarshaller unmarshaller) {
        if (this.getMembers().size() < 1) {
            unmarshaller.throwException("need at least 1 elements in Member");
        }
    }

    @Override
    protected int getState(String elementName) throws XMLStreamException {
        if (elementName.equals("Member")) {
            return 6;
        }
        int superState = super.getState(elementName);
        if (superState > 0) {
            return superState;
        }
        return -1;
    }

    @Override
    protected void parseElement(MithraGeneratorUnmarshaller unmarshaller, int state, String elementName) throws XMLStreamException {
        if (state < 6) {
            super.parseElement(unmarshaller, state, elementName);
        }
        if (elementName.equals("Member")) {
            EnumerationMemberType _member = new EnumerationMemberType();
            _member.parse(unmarshaller, "Member");
            _member._setParent(this);
            this.getMembers().add(_member);
        }
    }

    public List<EnumerationMemberType> getMembers() {
        return this.members;
    }

    public void setMembers(List<EnumerationMemberType> members) {
        this.members = members;
    }

    public boolean isMembersSet() {
        return this.members != null && this.members.size() > 0;
    }

    @Override
    protected void marshallAttributes(MithraGeneratorMarshaller marshaller) throws IOException {
        super.marshallAttributes(marshaller);
    }

    @Override
    protected void marshallContent(MithraGeneratorMarshaller marshaller) throws IOException {
    }

    @Override
    protected void marshallElements(MithraGeneratorMarshaller marshaller) throws IOException {
        super.marshallElements(marshaller);
        if (this.isMembersSet()) {
            for (EnumerationMemberType member : this.members) {
                member.toXml(marshaller, "Member");
            }
        }
    }

    @Override
    public void toXml(MithraGeneratorMarshaller marshaller, String tagName) throws IOException {
        marshaller.writeStartTag(tagName);
        this.marshallAttributes(marshaller);
        this.marshallContent(marshaller);
        this.marshallElements(marshaller);
        marshaller.writeEndTag(tagName);
    }
}

