/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.metamodel;

import com.gs.fw.common.mithra.generator.metamodel.AsOfAttributeInterfaceType;
import com.gs.fw.common.mithra.generator.metamodel.AttributeInterfaceType;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorMarshaller;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorUnmarshaller;
import com.gs.fw.common.mithra.generator.metamodel.RelationshipInterfaceType;
import com.gs.fw.common.mithra.generator.metamodel.SourceAttributeInterfaceType;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MithraInterfaceTypeAbstract
implements Serializable {
    private static Map<String, Integer> elementNameStates = new HashMap<String, Integer>();
    private String packageName;
    private String className;
    private List<String> superInterfaces = MithraGeneratorUnmarshaller.emptyList();
    private List<String> imports = MithraGeneratorUnmarshaller.emptyList();
    private List<AsOfAttributeInterfaceType> asOfAttributes = MithraGeneratorUnmarshaller.emptyList();
    private SourceAttributeInterfaceType sourceAttribute;
    private List<AttributeInterfaceType> attributes = MithraGeneratorUnmarshaller.emptyList();
    private List<RelationshipInterfaceType> relationships = MithraGeneratorUnmarshaller.emptyList();
    private Object _parent;

    public Object parent() {
        return this._parent;
    }

    public void _setParent(Object parent) {
        this._parent = parent;
    }

    public void parse(MithraGeneratorUnmarshaller unmarshaller, String typeName) throws XMLStreamException {
        this.parseElements(unmarshaller, typeName);
    }

    protected void initListElements(MithraGeneratorUnmarshaller unmarshaller) {
        this.superInterfaces = unmarshaller.newList();
        this.imports = unmarshaller.newList();
        this.asOfAttributes = unmarshaller.newList();
        this.attributes = unmarshaller.newList();
        this.relationships = unmarshaller.newList();
    }

    protected void parseElements(MithraGeneratorUnmarshaller unmarshaller, String typeName) throws XMLStreamException {
        this.initListElements(unmarshaller);
        int eventType = unmarshaller.getNextStartOrEnd();
        if (!unmarshaller.isAtEnd(eventType, typeName)) {
            XMLStreamReader xmlStreamReader = unmarshaller.getXmlStreamReader();
            int currentElementState = Integer.MAX_VALUE;
            int state = 0;
            while (eventType == 1) {
                String elementName = xmlStreamReader.getLocalName();
                currentElementState = this.getState(elementName);
                if (state <= currentElementState) {
                    if (state < 0) {
                        unmarshaller.throwException("unexpected element in MithraInterfaceType: " + elementName);
                    }
                } else {
                    unmarshaller.throwException("element out of order " + elementName + " in type MithraInterfaceType");
                }
                this.parseElement(unmarshaller, state, elementName);
                state = currentElementState;
                eventType = unmarshaller.getNextStartOrEnd();
            }
            if (state < 2) {
                unmarshaller.throwException("expecting at least one element of type ClassName in MithraInterfaceType");
            }
            unmarshaller.expectEnd(eventType, typeName);
            this.checkListMinOccurs(unmarshaller);
        }
    }

    protected void checkListMinOccurs(MithraGeneratorUnmarshaller unmarshaller) {
    }

    protected int getState(String elementName) throws XMLStreamException {
        Integer state = elementNameStates.get(elementName);
        if (state != null) {
            return state;
        }
        return -1;
    }

    protected void parseElement(MithraGeneratorUnmarshaller unmarshaller, int state, String elementName) throws XMLStreamException {
        if (elementName.equals("PackageName")) {
            if (!this.isPackageNameSet()) {
                this.setPackageName(unmarshaller.parseTokenString("PackageName"));
            } else {
                unmarshaller.throwException("too many occurrences of element PackageName in type MithraInterfaceType. Max occurrences is 1");
            }
        }
        if (elementName.equals("ClassName")) {
            if (!this.isClassNameSet()) {
                this.setClassName(unmarshaller.parseTokenString("ClassName"));
            } else {
                unmarshaller.throwException("too many occurrences of element ClassName in type MithraInterfaceType. Max occurrences is 1");
            }
        }
        if (elementName.equals("SuperInterface")) {
            this.getSuperInterfaces().add(unmarshaller.parseTokenString("SuperInterface"));
        }
        if (elementName.equals("Import")) {
            this.getImports().add(unmarshaller.parseTokenString("Import"));
        }
        if (elementName.equals("AsOfAttribute")) {
            if (this.asOfAttributes.size() < 2) {
                AsOfAttributeInterfaceType _asOfAttribute = new AsOfAttributeInterfaceType();
                _asOfAttribute.parse(unmarshaller, "AsOfAttribute");
                _asOfAttribute._setParent(this);
                this.getAsOfAttributes().add(_asOfAttribute);
            } else {
                unmarshaller.throwException("too many occurrences of element AsOfAttribute in type MithraInterfaceType. Max occurrences is 2");
            }
        }
        if (elementName.equals("SourceAttribute")) {
            if (!this.isSourceAttributeSet()) {
                SourceAttributeInterfaceType _sourceAttribute = new SourceAttributeInterfaceType();
                _sourceAttribute.parse(unmarshaller, "SourceAttribute");
                _sourceAttribute._setParent(this);
                this.setSourceAttribute(_sourceAttribute);
            } else {
                unmarshaller.throwException("too many occurrences of element SourceAttribute in type MithraInterfaceType. Max occurrences is 1");
            }
        }
        if (elementName.equals("Attribute")) {
            AttributeInterfaceType _attribute = new AttributeInterfaceType();
            _attribute.parse(unmarshaller, "Attribute");
            _attribute._setParent(this);
            this.getAttributes().add(_attribute);
        }
        if (elementName.equals("Relationship")) {
            RelationshipInterfaceType _relationship = new RelationshipInterfaceType();
            _relationship.parse(unmarshaller, "Relationship");
            _relationship._setParent(this);
            this.getRelationships().add(_relationship);
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public boolean isPackageNameSet() {
        return this.packageName != null;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isClassNameSet() {
        return this.className != null;
    }

    public List<String> getSuperInterfaces() {
        return this.superInterfaces;
    }

    public void setSuperInterfaces(List<String> superInterfaces) {
        this.superInterfaces = superInterfaces;
    }

    public boolean isSuperInterfacesSet() {
        return this.superInterfaces != null && this.superInterfaces.size() > 0;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public void setImports(List<String> imports) {
        this.imports = imports;
    }

    public boolean isImportsSet() {
        return this.imports != null && this.imports.size() > 0;
    }

    public List<AsOfAttributeInterfaceType> getAsOfAttributes() {
        return this.asOfAttributes;
    }

    public void setAsOfAttributes(List<AsOfAttributeInterfaceType> asOfAttributes) {
        this.asOfAttributes = asOfAttributes;
    }

    public boolean isAsOfAttributesSet() {
        return this.asOfAttributes != null && this.asOfAttributes.size() > 0;
    }

    public SourceAttributeInterfaceType getSourceAttribute() {
        return this.sourceAttribute;
    }

    public void setSourceAttribute(SourceAttributeInterfaceType sourceAttribute) {
        this.sourceAttribute = sourceAttribute;
    }

    public boolean isSourceAttributeSet() {
        return this.sourceAttribute != null;
    }

    public List<AttributeInterfaceType> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<AttributeInterfaceType> attributes) {
        this.attributes = attributes;
    }

    public boolean isAttributesSet() {
        return this.attributes != null && this.attributes.size() > 0;
    }

    public List<RelationshipInterfaceType> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<RelationshipInterfaceType> relationships) {
        this.relationships = relationships;
    }

    public boolean isRelationshipsSet() {
        return this.relationships != null && this.relationships.size() > 0;
    }

    protected void marshallAttributes(MithraGeneratorMarshaller marshaller) throws IOException {
    }

    protected void marshallContent(MithraGeneratorMarshaller marshaller) throws IOException {
    }

    protected void marshallElements(MithraGeneratorMarshaller marshaller) throws IOException {
        if (this.isPackageNameSet()) {
            marshaller.writeSimpleTag("PackageName", this.packageName);
        }
        if (this.isClassNameSet()) {
            marshaller.writeSimpleTag("ClassName", this.className);
        }
        if (this.isSuperInterfacesSet()) {
            for (String superInterface : this.superInterfaces) {
                marshaller.writeSimpleTag("SuperInterface", superInterface);
            }
        }
        if (this.isImportsSet()) {
            for (String import_ : this.imports) {
                marshaller.writeSimpleTag("Import", import_);
            }
        }
        if (this.isAsOfAttributesSet()) {
            for (AsOfAttributeInterfaceType asOfAttribute : this.asOfAttributes) {
                asOfAttribute.toXml(marshaller, "AsOfAttribute");
            }
        }
        if (this.isSourceAttributeSet()) {
            this.sourceAttribute.toXml(marshaller, "SourceAttribute");
        }
        if (this.isAttributesSet()) {
            for (AttributeInterfaceType attribute : this.attributes) {
                attribute.toXml(marshaller, "Attribute");
            }
        }
        if (this.isRelationshipsSet()) {
            for (RelationshipInterfaceType relationship : this.relationships) {
                relationship.toXml(marshaller, "Relationship");
            }
        }
    }

    public void toXml(MithraGeneratorMarshaller marshaller, String tagName) throws IOException {
        marshaller.writeStartTag(tagName);
        this.marshallAttributes(marshaller);
        this.marshallContent(marshaller);
        this.marshallElements(marshaller);
        marshaller.writeEndTag(tagName);
    }

    static {
        elementNameStates.put("PackageName", 1);
        elementNameStates.put("ClassName", 2);
        elementNameStates.put("SuperInterface", 3);
        elementNameStates.put("Import", 4);
        elementNameStates.put("AsOfAttribute", 5);
        elementNameStates.put("SourceAttribute", 6);
        elementNameStates.put("Attribute", 7);
        elementNameStates.put("Relationship", 8);
    }
}

