/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.metamodel;

import com.gs.fw.common.mithra.generator.metamodel.EmbeddedValueMappingType;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorMarshaller;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorUnmarshaller;
import com.gs.fw.common.mithra.generator.metamodel.NestedEmbeddedValueType;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NestedEmbeddedValueTypeAbstract
implements Serializable {
    private String name;
    private boolean finalGetter = false;
    private boolean _isFinalGetterSet;
    private List<EmbeddedValueMappingType> mappings = MithraGeneratorUnmarshaller.emptyList();
    private List<NestedEmbeddedValueType> embeddedValues = MithraGeneratorUnmarshaller.emptyList();
    private Object _parent;

    public Object parent() {
        return this._parent;
    }

    public void _setParent(Object parent) {
        this._parent = parent;
    }

    public void parse(MithraGeneratorUnmarshaller unmarshaller, String typeName) throws XMLStreamException {
        this.parseAttributes(unmarshaller);
        this.parseElements(unmarshaller, typeName);
    }

    protected void initListElements(MithraGeneratorUnmarshaller unmarshaller) {
        this.mappings = unmarshaller.newList();
        this.embeddedValues = unmarshaller.newList();
    }

    protected void parseElements(MithraGeneratorUnmarshaller unmarshaller, String typeName) throws XMLStreamException {
        this.initListElements(unmarshaller);
        int eventType = unmarshaller.getNextStartOrEnd();
        if (!unmarshaller.isAtEnd(eventType, typeName)) {
            XMLStreamReader xmlStreamReader = unmarshaller.getXmlStreamReader();
            int currentElementState = Integer.MAX_VALUE;
            int state = 0;
            while (eventType == 1) {
                String elementName = xmlStreamReader.getLocalName();
                currentElementState = this.getState(elementName);
                if (state <= currentElementState) {
                    if (state < 0) {
                        unmarshaller.throwException("unexpected element in NestedEmbeddedValueType: " + elementName);
                    }
                } else {
                    unmarshaller.throwException("element out of order " + elementName + " in type NestedEmbeddedValueType");
                }
                this.parseElement(unmarshaller, state, elementName);
                state = currentElementState;
                eventType = unmarshaller.getNextStartOrEnd();
            }
            unmarshaller.expectEnd(eventType, typeName);
            this.checkListMinOccurs(unmarshaller);
        }
    }

    protected void checkListMinOccurs(MithraGeneratorUnmarshaller unmarshaller) {
    }

    protected int getState(String elementName) throws XMLStreamException {
        if (elementName.equals("Mapping")) {
            return 1;
        }
        if (elementName.equals("EmbeddedValue")) {
            return 2;
        }
        return -1;
    }

    protected void parseElement(MithraGeneratorUnmarshaller unmarshaller, int state, String elementName) throws XMLStreamException {
        if (elementName.equals("Mapping")) {
            EmbeddedValueMappingType _mapping = new EmbeddedValueMappingType();
            _mapping.parse(unmarshaller, "Mapping");
            _mapping._setParent(this);
            this.getMappings().add(_mapping);
        }
        if (elementName.equals("EmbeddedValue")) {
            NestedEmbeddedValueType _embeddedValue = new NestedEmbeddedValueType();
            _embeddedValue.parse(unmarshaller, "EmbeddedValue");
            _embeddedValue._setParent(this);
            this.getEmbeddedValues().add(_embeddedValue);
        }
    }

    protected void parseAttributes(MithraGeneratorUnmarshaller unmarshaller) throws XMLStreamException {
        XMLStreamReader xmlStreamReader = unmarshaller.getXmlStreamReader();
        int attributes = xmlStreamReader.getAttributeCount();
        for (int i = 0; i < attributes; ++i) {
            String attributeValue;
            String attributeName = xmlStreamReader.getAttributeName(i).getLocalPart();
            if (this.parseAttribute(unmarshaller, attributeName, attributeValue = xmlStreamReader.getAttributeValue(i))) continue;
            unmarshaller.unknownAttribute(attributeName, attributeValue);
        }
        this.checkMandatoryAttributes(unmarshaller);
    }

    protected boolean parseAttribute(MithraGeneratorUnmarshaller unmarshaller, String attributeName, String attributeValue) throws XMLStreamException {
        if (attributeName.equals("name")) {
            this.setName(unmarshaller.toToken("name", attributeValue));
            return true;
        }
        if (attributeName.equals("finalGetter")) {
            this.setFinalGetter(unmarshaller.parseBoolean("finalGetter", attributeValue));
            return true;
        }
        return false;
    }

    protected void checkMandatoryAttributes(MithraGeneratorUnmarshaller unmarshaller) {
        if (!this.isNameSet()) {
            unmarshaller.throwException("Attribute 'name' is not set in element '" + this.getClass().getName() + "'");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNameSet() {
        return this.name != null;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isFinalGetter() {
        return this.finalGetter;
    }

    public void setFinalGetter(boolean finalGetter) {
        this.finalGetter = finalGetter;
        this._isFinalGetterSet = true;
    }

    public boolean isFinalGetterSet() {
        return this._isFinalGetterSet;
    }

    public void unsetFinalGetter() {
        this._isFinalGetterSet = false;
        this.finalGetter = false;
    }

    public List<EmbeddedValueMappingType> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<EmbeddedValueMappingType> mappings) {
        this.mappings = mappings;
    }

    public boolean isMappingsSet() {
        return this.mappings != null && this.mappings.size() > 0;
    }

    public List<NestedEmbeddedValueType> getEmbeddedValues() {
        return this.embeddedValues;
    }

    public void setEmbeddedValues(List<NestedEmbeddedValueType> embeddedValues) {
        this.embeddedValues = embeddedValues;
    }

    public boolean isEmbeddedValuesSet() {
        return this.embeddedValues != null && this.embeddedValues.size() > 0;
    }

    protected void marshallAttributes(MithraGeneratorMarshaller marshaller) throws IOException {
        if (this.isNameSet()) {
            marshaller.writeAttribute("name", this.name);
        }
        if (this.isFinalGetterSet()) {
            marshaller.writeAttribute("finalGetter", this.finalGetter);
        }
    }

    protected void marshallContent(MithraGeneratorMarshaller marshaller) throws IOException {
    }

    protected void marshallElements(MithraGeneratorMarshaller marshaller) throws IOException {
        if (this.isMappingsSet()) {
            for (EmbeddedValueMappingType mapping : this.mappings) {
                mapping.toXml(marshaller, "Mapping");
            }
        }
        if (this.isEmbeddedValuesSet()) {
            for (NestedEmbeddedValueType embeddedValue : this.embeddedValues) {
                embeddedValue.toXml(marshaller, "EmbeddedValue");
            }
        }
    }

    public void toXml(MithraGeneratorMarshaller marshaller, String tagName) throws IOException {
        marshaller.writeStartTag(tagName);
        this.marshallAttributes(marshaller);
        this.marshallContent(marshaller);
        this.marshallElements(marshaller);
        marshaller.writeEndTag(tagName);
    }
}

