/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.metamodel;

import com.gs.fw.common.mithra.generator.Cardinality;
import com.gs.fw.common.mithra.generator.CommonWrapper;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.RelationshipAttribute;
import com.gs.fw.common.mithra.generator.metamodel.MithraInterfaceType;
import com.gs.fw.common.mithra.generator.metamodel.RelationshipInterfaceTypeAbstract;
import com.gs.fw.common.mithra.generator.util.StringUtility;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipInterfaceType
extends RelationshipInterfaceTypeAbstract {
    private CommonWrapper relatedMithraObject;

    public Cardinality getCardinalityObject() {
        return Cardinality.getByName(this.getCardinality().value());
    }

    @Override
    public String getParameters() {
        if (super.getParameters() != null) {
            return super.getParameters();
        }
        return "";
    }

    public void resolveRelatedObject(Map<String, MithraInterfaceType> mithraInterfaces, Map<String, MithraObjectTypeWrapper> mithraObjects, List<String> errorMessages) {
        this.relatedMithraObject = mithraInterfaces.get(this.getRelatedObject());
        if (this.relatedMithraObject == null) {
            this.relatedMithraObject = mithraObjects.get(this.getRelatedObject());
        }
        if (this.relatedMithraObject == null) {
            errorMessages.add("The Relationship " + this.getName() + " has been defined  to have a related object name " + this.getRelatedObject() + " which is neither a MithraObject nor a MithraInterface. RelatedObject of a MithraInterface Relationships needs to be a valid MithraObject or MithraInterface");
        }
    }

    public String getRelatedObjectClassNameForTemplate() {
        if (this.relatedMithraObject instanceof MithraObjectTypeWrapper) {
            MithraObjectTypeWrapper relatedObj = (MithraObjectTypeWrapper)this.relatedMithraObject;
            if (this.getCardinality().isManyToOne() || this.getCardinality().isOneToOne()) {
                return relatedObj.getClassName() + "Finder." + relatedObj.getClassName() + "SingleFinderForRelatedClasses";
            }
            return relatedObj.getClassName() + "Finder." + relatedObj.getClassName() + "CollectionFinderForRelatedClasses";
        }
        MithraInterfaceType relatedObj = (MithraInterfaceType)this.relatedMithraObject;
        return relatedObj.getClassName() + "Finder";
    }

    public CommonWrapper getRelatedMithraObject() {
        return this.relatedMithraObject;
    }

    public boolean validateRelationship(Map<String, MithraInterfaceType> mithraInterfaces, RelationshipAttribute localRelationshipAttribute, String mithraObjectClassname, String mithraInterfaceName, List<String> errors) {
        if (localRelationshipAttribute == null) {
            errors.add("Object " + mithraObjectClassname + " is defined to implement the MithraInterface " + mithraInterfaceName + " but does not define the relationship - " + this.getName());
            return false;
        }
        if (!this.isRelatedObjectAssignableFrom(localRelationshipAttribute.getRelatedObject(), mithraInterfaces, mithraObjectClassname, errors)) {
            return false;
        }
        if (!this.getCardinalityObject().equals(localRelationshipAttribute.getCardinality())) {
            errors.add("Object " + mithraObjectClassname + " has a relationship " + this.getName() + " with cardinality " + localRelationshipAttribute.getCardinality() + "which is not equal with the cardinality " + this.getCardinalityObject() + "of the mithrainterface " + mithraInterfaceName);
            return false;
        }
        if (!this.getParameters().equals(localRelationshipAttribute.getParameters())) {
            errors.add("Object " + mithraObjectClassname + " has a relationship " + this.getName() + " with parameters " + localRelationshipAttribute.getParameters() + "and is not equal to the parameters " + this.getParameters() + "of the mithrainterface " + mithraInterfaceName);
            return false;
        }
        return true;
    }

    public boolean isRelatedObjectAssignableFrom(MithraObjectTypeWrapper relatedObject, Map<String, MithraInterfaceType> mithraInterfaces, String mithraObjectClassname, List<String> errors) {
        String relatedObjectName;
        String localRelatedObjectName = this.getRelatedObject();
        if (localRelatedObjectName.equals(relatedObjectName = relatedObject.getWrapped().getClassName())) {
            return true;
        }
        List<String> relatedObjInterfaces = relatedObject.getWrapped().getMithraInterfaces();
        for (String interfaceName : relatedObjInterfaces) {
            if (!localRelatedObjectName.equals(interfaceName) && !this.checkSuperInterfaces(localRelatedObjectName, interfaceName, mithraInterfaces)) continue;
            return true;
        }
        errors.add("Object" + mithraObjectClassname + " has a relationship " + this.getName() + " with relatedObject name " + relatedObjectName + " which is not equal to " + localRelatedObjectName + " RelatedObjects must be the same or they must be another mithrainterface or a superinterface");
        return false;
    }

    private boolean checkSuperInterfaces(String localRelationshipName, String interfaceName, Map<String, MithraInterfaceType> mithraInterfaces) {
        MithraInterfaceType interfaceObject = mithraInterfaces.get(interfaceName);
        Set<MithraInterfaceType> allSuperInterfaces = interfaceObject.getAllSuperInterfaces();
        for (MithraInterfaceType superInterface : allSuperInterfaces) {
            if (!superInterface.getClassName().equals(localRelationshipName)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompatibleWithSuperRelationship(RelationshipInterfaceType superRelationshipType, List<String> errors) {
        if (!this.getRelatedObject().equals(superRelationshipType.getRelatedObject())) {
            errors.add("Inconsistent Relationship. The RelatedObject" + this.getRelatedObject() + " does not match the related object in SuperInterface. " + "SuperInterface RelatedObject : " + superRelationshipType.getRelatedObject());
            return false;
        }
        if (!this.getCardinalityObject().equals(superRelationshipType.getCardinalityObject())) {
            errors.add("Inconsistent Relationship. The Relationship cardinality " + this.getCardinalityObject() + " does not match the cardinality in SuperInterface. " + "SuperInterface cardinality : " + superRelationshipType.getCardinalityObject());
            return false;
        }
        if (!this.getParameters().equals(superRelationshipType.getParameters())) {
            errors.add("Inconsistent Relationship. The Relationship parameters " + this.getParameters() + " does not match the parameters in SuperInterface. " + "SuperInterface parameters : " + superRelationshipType.getParameters());
            return false;
        }
        return true;
    }

    public String getGetter() {
        return "get" + StringUtility.firstLetterToUpper(this.getName());
    }

    public boolean hasSetter() {
        return !this.hasParameters();
    }

    public boolean hasParameters() {
        return super.getParameters() != null && super.getParameters().trim().length() > 0;
    }

    public String getSetter() {
        return "set" + StringUtility.firstLetterToUpper(this.getName());
    }

    public String getTypeAsString() {
        String className;
        String type = className = this.relatedMithraObject.getClassName();
        if (this.getCardinality().isOneToMany() || this.getCardinality().isManyToMany()) {
            type = type + "List";
        }
        return StringUtility.trimPackage(type);
    }
}

