/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.metamodel;

import com.gs.fw.common.mithra.generator.SourceAttribute;
import com.gs.fw.common.mithra.generator.metamodel.SourceAttributeInterfaceTypeAbstract;
import com.gs.fw.common.mithra.generator.type.JavaType;
import com.gs.fw.common.mithra.generator.util.StringUtility;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceAttributeInterfaceType
extends SourceAttributeInterfaceTypeAbstract {
    private JavaType getType() {
        return JavaType.create(this.getJavaType());
    }

    public String getTypeAsString() {
        return this.getType().getJavaTypeString();
    }

    public String getGetter() {
        return "get" + StringUtility.firstLetterToUpper(this.getName());
    }

    public String getSetter() {
        return "set" + StringUtility.firstLetterToUpper(this.getName());
    }

    public String getTypeAsStringPrimary() {
        return this.getType().getJavaTypeStringPrimary();
    }

    public String getAttributeClassName() {
        return this.getTypeAsStringPrimary() + "Attribute";
    }

    public boolean validAttribute(SourceAttribute sourceAttribute, String className, String mithraInterfaceName, List<String> errors) {
        if (!this.getName().equals(sourceAttribute.getName()) || !this.getTypeAsString().equals(sourceAttribute.getType().getJavaTypeString())) {
            errors.add("Object " + className + " is defined to be implement the MithraInterface " + mithraInterfaceName + " but the SourceAttribute - " + this.getName() + " has either not been defined or has a incorrect name or type. ");
            return false;
        }
        return true;
    }

    public void isCompatibleWithSuperSourceAttribute(SourceAttributeInterfaceType superSourceAttributeType, List<String> errorMessages) {
        if (!this.getName().equals(superSourceAttributeType.getName()) || !this.getTypeAsString().equals(superSourceAttributeType.getTypeAsString())) {
            errorMessages.add("Inconsistent SourceAttribute. " + this.getName() + " has a type " + this.getTypeAsString() + " which is not consistent with its SuperInterface Type : " + superSourceAttributeType.getName() + ", " + superSourceAttributeType.getTypeAsString());
        }
    }
}

