/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.queryparser;

import com.gs.fw.common.mithra.generator.MithraGeneratorException;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.queryparser.LeafLevelExpression;
import com.gs.fw.common.mithra.generator.queryparser.MithraQL;
import com.gs.fw.common.mithra.generator.queryparser.MithraQLVisitor;
import com.gs.fw.common.mithra.generator.queryparser.SimpleNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTAndExpression
extends SimpleNode {
    private MithraObjectTypeWrapper owner;
    private boolean involvesThis = true;

    public ASTAndExpression(int id) {
        super(id);
    }

    public ASTAndExpression(MithraQL p, int id) {
        super(p, id);
    }

    @Override
    public void checkConsistency(MithraObjectTypeWrapper owner, Map allObjects, List<String> errors) {
        this.owner = owner;
    }

    @Override
    public Object jjtAccept(MithraQLVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void addLeafLevelExpressionsToList(List list) {
        for (int i = 0; i < this.children.length; ++i) {
            SimpleNode s = (SimpleNode)this.children[i];
            s.addLeafLevelExpressionsToList(list);
        }
    }

    @Override
    public List getChainedExpressions() {
        ArrayList<SimpleNode> result = new ArrayList<SimpleNode>();
        ArrayList operands = new ArrayList();
        this.addLeafLevelExpressionsToList(operands);
        SimpleNode firstExpression = this.getOwnerOperations(operands);
        result.add(firstExpression);
        if (operands.size() > 1) {
            HashSet firstSet = new HashSet();
            firstExpression.addDependentClassesToSet(firstSet);
            if (!this.involvesThis) {
                firstSet.remove(this.owner);
            }
            MithraObjectTypeWrapper[] array = new MithraObjectTypeWrapper[firstSet.size()];
            firstSet.toArray(array);
            if (array.length > 1) {
                throw new MithraGeneratorException("multi-cross-join not yet implemented");
            }
            ASTAndExpression and = new ASTAndExpression(6);
            and.children = new SimpleNode[operands.size()];
            operands.toArray(and.children);
            and.owner = array[0];
            and.involvesThis = false;
            result.add(and);
        } else {
            result.add((SimpleNode)operands.get(0));
        }
        return result;
    }

    public MithraObjectTypeWrapper getOwner() {
        return this.owner;
    }

    public void setOwner(MithraObjectTypeWrapper owner) {
        this.owner = owner;
    }

    public boolean isInvolvesThis() {
        return this.involvesThis;
    }

    public void setInvolvesThis(boolean involvesThis) {
        this.involvesThis = involvesThis;
    }

    protected SimpleNode getOwnerOperations(ArrayList operands) {
        ArrayList<LeafLevelExpression> ownerExpressions = new ArrayList<LeafLevelExpression>();
        int i = 0;
        while (i < operands.size()) {
            LeafLevelExpression leafLevelExpression = (LeafLevelExpression)operands.get(i);
            if (this.involvesThis && leafLevelExpression.involvesThis() || !this.involvesThis && leafLevelExpression.involvesClassAsNonThis(this.owner)) {
                ownerExpressions.add(leafLevelExpression);
                operands.remove(i);
                continue;
            }
            ++i;
        }
        if (ownerExpressions.size() == 0) {
            throw new MithraGeneratorException("relationship must depend on the current object");
        }
        HashSet dependentSet = new HashSet();
        for (int i2 = 0; i2 < ownerExpressions.size(); ++i2) {
            SimpleNode leafLevelExpression = (SimpleNode)ownerExpressions.get(i2);
            leafLevelExpression.addDependentClassesToSet(dependentSet);
        }
        if (!this.involvesThis) {
            dependentSet.remove(this.owner);
        }
        MithraObjectTypeWrapper[] array = new MithraObjectTypeWrapper[dependentSet.size()];
        dependentSet.toArray(array);
        if (array.length > 1) {
            throw new MithraGeneratorException("multi-cross-join not yet implemented");
        }
        int i3 = 0;
        while (i3 < operands.size()) {
            LeafLevelExpression leafLevelExpression = (LeafLevelExpression)operands.get(i3);
            if (leafLevelExpression.involvesOnlyThis(array[0])) {
                ownerExpressions.add(leafLevelExpression);
                operands.remove(i3);
                continue;
            }
            ++i3;
        }
        if (ownerExpressions.size() > 1) {
            ASTAndExpression and = new ASTAndExpression(6);
            and.children = new SimpleNode[ownerExpressions.size()];
            ownerExpressions.toArray(and.children);
            and.owner = this.owner;
            return and;
        }
        return (SimpleNode)ownerExpressions.get(0);
    }

    @Override
    public String constructFilterExpr() {
        ArrayList<String> list = new ArrayList<String>(this.jjtGetNumChildren());
        for (int i = 0; i < this.children.length; ++i) {
            String child = ((SimpleNode)this.children[i]).constructFilterExpr();
            if (child == null || child.length() <= 0) continue;
            list.add(child);
        }
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() == 1) {
            return (String)list.get(0);
        }
        String expr = "(" + (String)list.get(0) + ")";
        for (int i = 1; i < list.size(); ++i) {
            expr = expr + " && (" + (String)list.get(i) + ")";
        }
        return expr;
    }
}

