/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.queryparser;

import com.gs.fw.common.mithra.generator.AbstractAttribute;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.queryparser.MithraQL;
import com.gs.fw.common.mithra.generator.queryparser.MithraQLVisitor;
import com.gs.fw.common.mithra.generator.queryparser.SimpleNode;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTAttributeName
extends SimpleNode {
    private String name;
    private AbstractAttribute attribute;
    private boolean belongsToThis;
    private MithraObjectTypeWrapper owner;

    public ASTAttributeName(int id) {
        super(id);
    }

    public ASTAttributeName(MithraQL p, int id) {
        super(p, id);
    }

    public ASTAttributeName(AbstractAttribute left, boolean belongsToThis) {
        super(0);
        this.belongsToThis = belongsToThis;
        this.attribute = left;
        this.owner = left.getOwner();
        this.name = belongsToThis ? "this." + this.attribute.getName() : this.owner.getClassName() + "." + this.attribute.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public void checkConsistency(MithraObjectTypeWrapper owner, Map allObjects, List<String> errors) {
        if (this.attribute != null) {
            return;
        }
        String error = this.findAttribute(owner, allObjects);
        if (error != null) {
            errors.add(error);
        }
    }

    @Override
    public void addImport(MithraObjectTypeWrapper owner, Map allObjects, List<String> errors) {
        String[] nameSplit = this.getName().split("\\.");
        if (nameSplit.length == 2) {
            String className = nameSplit[0];
            if (!className.equals("this")) {
                MithraObjectTypeWrapper wrapper = (MithraObjectTypeWrapper)allObjects.get(className);
                owner.addToRequiredClasses(wrapper.getPackageName(), wrapper.getDataClassName());
                owner.addToRequiredClasses(wrapper.getPackageName(), wrapper.getClassName());
                owner.addToRequiredClasses(wrapper.getPackageName(), wrapper.getAbstractClassName());
                owner.addToRequiredClasses(wrapper.getPackageName(), wrapper.getFinderClassName());
                owner.addToRequiredClasses(wrapper.getPackageName(), wrapper.getListClassName());
                if (wrapper.isGenerateInterfaces()) {
                    owner.addToRequiredClasses(wrapper.getPackageName(), wrapper.getListInterfaceName());
                    owner.addToRequiredClasses(wrapper.getPackageName(), wrapper.getImplClassName());
                }
            }
        } else if (errors != null) {
            errors.add("Attribute '" + this.getName() + "' is not in [className.attribute] format" + nameSplit.length);
        }
    }

    public String findAttribute(MithraObjectTypeWrapper owner, Map allObjects) {
        String[] nameSplit = this.getName().split("\\.");
        if (nameSplit.length == 2) {
            MithraObjectTypeWrapper wrapper;
            String className = nameSplit[0];
            String attributeName = nameSplit[1];
            if (className.equals("this")) {
                className = owner.getClassName();
                this.belongsToThis = true;
                this.owner = owner;
            }
            if (!allObjects.containsKey(className)) {
                return "Class name '" + className + "'" + "not defined. Have you added a xml file for this class?";
            }
            this.owner = wrapper = (MithraObjectTypeWrapper)allObjects.get(className);
            this.attribute = wrapper.getAttributeByName(attributeName);
            if (this.attribute == null) {
                return "Attribute '" + attributeName + "' does not exist in class '" + className + "'";
            }
            return null;
        }
        return "Attribute '" + this.getName() + "' is not in [className.attribute] format" + nameSplit.length;
    }

    public boolean isSourceAttribute() {
        return this.attribute.isSourceAttribute();
    }

    public boolean isAsOfAttribute() {
        return this.attribute.isAsOfAttribute();
    }

    public AbstractAttribute getAttribute() {
        return this.attribute;
    }

    public boolean isComparableTo(ASTAttributeName other) {
        return this.getAttribute().isComparableTo(other.getAttribute());
    }

    public boolean isComparableTo(ASTLiteral other) {
        return this.getAttribute().isComparableTo(other);
    }

    public boolean belongsToThis() {
        return this.belongsToThis;
    }

    public MithraObjectTypeWrapper getOwner() {
        return this.owner;
    }

    public String getTopLevelFinderAttribute() {
        return this.owner.getClassName() + "Finder." + this.getAttribute().getName() + "()";
    }

    @Override
    public String getFinderString() {
        return this.getTopLevelFinderAttribute();
    }

    @Override
    public Object jjtAccept(MithraQLVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void addDependentClassesToSet(Set set) {
        super.addDependentClassesToSet(set);
        if (!this.belongsToThis) {
            set.add(this.owner);
        }
    }

    public String getArgumentForInOperation(String values, MithraObjectTypeWrapper fromObject) {
        return this.getAttribute().getType().getArgumentForInOperation(values, fromObject);
    }

    @Override
    public boolean equalsOther(SimpleNode other) {
        if (other instanceof ASTAttributeName) {
            AbstractAttribute otherAttr = ((ASTAttributeName)other).getAttribute();
            return this.getAttribute().getName().equals(otherAttr.getName()) && this.getOwner().getClassName().equals(otherAttr.getOwner().getClassName());
        }
        return false;
    }
}

