/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.JavaType;

public class BigDecimalJavaType
extends JavaType {
    public boolean isBigDecimal() {
        return true;
    }

    public String getTypeName() {
        return "BIGDECIMAL";
    }

    public String getJavaTypeString() {
        return "BigDecimal";
    }

    public String getJavaTypeStringPrimary() {
        return "BigDecimal";
    }

    public String getIoType() {
        return "Object";
    }

    public String getIoCast() {
        return "(BigDecimal)";
    }

    public String convertToObject(String name) {
        return name;
    }

    public String convertToPrimitive(String name) {
        return name;
    }

    public boolean isPrimitive() {
        return false;
    }

    public int getSqlType() {
        return 3;
    }

    public String getSqlTypeAsString() {
        return "java.sql.Types.DECIMAL";
    }

    public String getSqlDataType() {
        return "decimal";
    }

    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForBigDecimal();
    }

    public String getDefaultInitialValue() {
        return "null";
    }

    public boolean isComparableTo(ASTLiteral node) {
        return node.isFloatingPoint() || node.isInteger();
    }

    public boolean isComparableTo(JavaType other) {
        return other instanceof BigDecimalJavaType;
    }

    public String getJavaTypeClass() {
        return "BigDecimal.class";
    }

    public String getObjectComparisonString(String obj1, String obj2) {
        return obj1 + ".equals(" + obj2 + ")";
    }

    public int getOffHeapSize() {
        throw new RuntimeException("not implemented");
    }
}

