/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.BeanState;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.JavaType;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class BooleanJavaType
extends PrimitiveWrapperJavaType {
    public String getTypeName() {
        return "BOOLEAN";
    }

    public String getJavaTypeString() {
        return "boolean";
    }

    public String getJavaTypeStringPrimary() {
        return "Boolean";
    }

    public String convertToObject(String name) {
        return "Boolean.valueOf(" + name + ")";
    }

    public String convertToPrimitive(String name) {
        return name + ".booleanValue()";
    }

    public boolean isNumber() {
        return false;
    }

    public int getSqlType() {
        return -7;
    }

    public String getSqlTypeAsString() {
        return "java.sql.Types.BIT";
    }

    public String getSqlDataType() {
        return "bit";
    }

    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        if (nullable) {
            return databaseType.getSqlDataTypeForNullableBoolean();
        }
        return databaseType.getSqlDataTypeForBoolean();
    }

    public String getDefaultInitialValue() {
        return "false";
    }

    public boolean isComparableTo(ASTLiteral node) {
        return node.isBoolean();
    }

    public boolean isComparableTo(JavaType other) {
        return other instanceof BooleanJavaType;
    }

    public String getValueIfNull(String valueIfNull) {
        Boolean result = Boolean.valueOf(valueIfNull);
        return result.toString();
    }

    public String getJavaTypeClass() {
        return "Boolean.TYPE";
    }

    public String getSetCollectionClass() {
        return "BooleanDirectSet";
    }

    public String getGetterPrefix() {
        return "is";
    }

    public String getBeanSetter(BeanState beanState) {
        return "setI" + beanState.getIntCount() + "AsBoolean";
    }

    public boolean isBoolean() {
        return true;
    }

    public int getOffHeapSize() {
        return 1;
    }

    public String getSqlTypeAsStringForNull() {
        return "dt.getNullableBooleanJavaSqlType()";
    }
}

