/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.JavaType;

public class ByteArrayJavaType
extends JavaType {
    public String getResultSetName() {
        return "Bytes";
    }

    public String getExtractionMethodName() {
        return "byteArrayValueOf";
    }

    public String getValueSetterMethodName() {
        return "setByteArrayValue";
    }

    public String getTypeName() {
        return "INT";
    }

    public String getJavaTypeString() {
        return "byte[]";
    }

    public String getJavaTypeStringPrimary() {
        return "ByteArray";
    }

    public String convertToObject(String name) {
        return name;
    }

    public String convertToPrimitive(String name) {
        throw new RuntimeException("byte[] is not primitive");
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public int getSqlType() {
        return -3;
    }

    public String getSqlTypeAsString() {
        return "java.sql.Types.VARBINARY";
    }

    public String getSqlDataType() {
        throw new RuntimeException("not applicable");
    }

    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForVarBinary();
    }

    public String getDefaultInitialValue() {
        return "null";
    }

    public boolean isComparableTo(ASTLiteral node) {
        return false;
    }

    public boolean isComparableTo(JavaType other) {
        return other instanceof ByteArrayJavaType;
    }

    public String getJavaTypeClass() {
        return "byte[].class";
    }

    public String getObjectComparisonString(String obj1, String obj2) {
        return "Arrays.equals(" + obj1 + ',' + obj2 + ')';
    }

    public boolean isArray() {
        return true;
    }

    public int getOffHeapSize() {
        throw new RuntimeException("not implemented");
    }
}

