/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class ByteJavaType
extends PrimitiveWrapperJavaType {
    public String getTypeName() {
        return "BYTE";
    }

    public String getJavaTypeString() {
        return "byte";
    }

    public String getJavaTypeStringPrimary() {
        return "Byte";
    }

    public String convertToObject(String name) {
        return "new Byte(" + name + ")";
    }

    public String convertToPrimitive(String name) {
        return name + ".byteValue()";
    }

    public int getSqlType() {
        return -6;
    }

    public String getSqlTypeAsString() {
        return "java.sql.Types.TINYINT";
    }

    public String getSqlDataType() {
        return "tinyint";
    }

    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForByte();
    }

    public String getDefaultInitialValue() {
        return "0";
    }

    public boolean isComparableTo(ASTLiteral node) {
        if (node.isInteger()) {
            int intValue = new Integer(node.getValue());
            return intValue >= -128 && intValue <= 127;
        }
        return false;
    }

    public String getJavaTypeClass() {
        return "Byte.TYPE";
    }

    public String parseLiteralAndCast(String value) {
        return "(byte)" + value;
    }

    public int getOffHeapSize() {
        return 1;
    }
}

