/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.JavaType;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class CharJavaType
extends PrimitiveWrapperJavaType {
    public String getTypeName() {
        return "CHAR";
    }

    public String getJavaTypeString() {
        return "char";
    }

    public String getResultSetName() {
        return "String";
    }

    public String getJavaTypeStringPrimary() {
        return "Char";
    }

    public String convertToObject(String name) {
        return this.getValueIfNull(name);
    }

    public String convertToPrimitive(String name) {
        return this.getValueIfNull(name);
    }

    public boolean isNumber() {
        return false;
    }

    public int getSqlType() {
        return 1;
    }

    public String getSqlTypeAsString() {
        return "java.sql.Types.CHAR";
    }

    public String getSqlDataType() {
        return "char";
    }

    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForChar();
    }

    public String getDefaultInitialValue() {
        return "' '";
    }

    public boolean isComparableTo(ASTLiteral node) {
        return node.isCharacter();
    }

    public boolean isComparableTo(JavaType other) {
        return other instanceof CharJavaType;
    }

    public String getValueIfNull(String valueIfNull) {
        if (valueIfNull.length() == 0) {
            return "' '";
        }
        return "'" + valueIfNull.substring(0, 1) + "'";
    }

    public String getJavaTypeClass() {
        return "Char.TYPE";
    }

    public String convertSqlParameter(String param) {
        return "String.valueOf(" + param + ")";
    }

    public int getOffHeapSize() {
        return 2;
    }
}

