/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.JavaType;
import com.gs.fw.common.mithra.generator.type.TimestampJavaType;

public class DateJavaType
extends JavaType {
    public String getTypeName() {
        return "DATE";
    }

    public String getJavaTypeString() {
        return "Date";
    }

    public String getJavaTypeStringPrimary() {
        return "Date";
    }

    public String getPrintableForm(String getter) {
        return "PrintablePreparedStatement.dateFormat.print(" + getter + ".getTime())";
    }

    public String getIoType() {
        return "Object";
    }

    public String getIoCast() {
        return "(Date)";
    }

    public String convertToObject(String name) {
        return name;
    }

    public String convertToPrimitive(String name) {
        return name;
    }

    public boolean isPrimitive() {
        return false;
    }

    public int getSqlType() {
        return 91;
    }

    public String getSqlTypeAsString() {
        return "java.sql.Types.DATE";
    }

    public String getSqlDataType() {
        return "date";
    }

    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForDateTime();
    }

    public String getDefaultInitialValue() {
        return "null";
    }

    public boolean isComparableTo(ASTLiteral node) {
        return node.isString();
    }

    public boolean isComparableTo(JavaType other) {
        return other instanceof DateJavaType || other instanceof TimestampJavaType;
    }

    public String getJavaTypeClass() {
        return "Date.class";
    }

    public String getObjectComparisonString(String obj1, String obj2) {
        return obj1 + ".equals(" + obj2 + ")";
    }

    public int getOffHeapSize() {
        return 8;
    }
}

