/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.BeanState;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class DoubleJavaType
extends PrimitiveWrapperJavaType {
    public String getTypeName() {
        return "DOUBLE";
    }

    public String getJavaTypeString() {
        return "double";
    }

    public String getJavaTypeStringPrimary() {
        return "Double";
    }

    public String convertToObject(String name) {
        return "new Double(" + name + ")";
    }

    public String convertToPrimitive(String name) {
        return name + ".doubleValue()";
    }

    public int getSqlType() {
        return 8;
    }

    public String getSqlTypeAsString() {
        return "java.sql.Types.DOUBLE";
    }

    public String getSqlDataType() {
        return "DOUBLE";
    }

    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForDouble();
    }

    public String getDefaultInitialValue() {
        return "0.00D";
    }

    public boolean isComparableTo(ASTLiteral node) {
        return node.isFloatingPoint() || node.isInteger();
    }

    public String getJavaTypeClass() {
        return "Double.TYPE";
    }

    public String getPrimitiveComparisonString(String p1, String p2) {
        return "Math.abs(" + p1 + " - " + p2 + ") > toleranceForFloatingPointFields";
    }

    public String getBeanGetter(int intCount, int longCount, int objectCount) {
        return "getL" + longCount + "AsDouble";
    }

    public boolean isBeanIntType() {
        return false;
    }

    public boolean isBeanLongType() {
        return true;
    }

    public String getBeanSetter(BeanState beanState) {
        return "setL" + beanState.getLongCount() + "AsDouble";
    }

    public int getOffHeapSize() {
        return 8;
    }
}

