/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.BeanState;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class FloatJavaType
extends PrimitiveWrapperJavaType {
    public String getTypeName() {
        return "FLOAT";
    }

    public String getJavaTypeString() {
        return "float";
    }

    public String getJavaTypeStringPrimary() {
        return "Float";
    }

    public String convertToObject(String name) {
        return "new Float(" + name + ")";
    }

    public String convertToPrimitive(String name) {
        return name + ".floatValue()";
    }

    public int getSqlType() {
        return 6;
    }

    public String getSqlDataType() {
        return "float";
    }

    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForFloat();
    }

    public String getSqlTypeAsString() {
        return "java.sql.Types.FLOAT";
    }

    public String getDefaultInitialValue() {
        return "0.00F";
    }

    public boolean isComparableTo(ASTLiteral node) {
        return node.isFloatingPoint() || node.isInteger();
    }

    public String getJavaTypeClass() {
        return "Float.TYPE";
    }

    public String getPrimitiveComparisonString(String p1, String p2) {
        return "Math.abs(" + p1 + " - " + p2 + ") > toleranceForFloatingPointFields";
    }

    public String parseLiteralAndCast(String value) {
        return "(float)" + value;
    }

    public String getBeanSetter(BeanState beanState) {
        return "setI" + beanState.getIntCount() + "AsFloat";
    }

    public int getOffHeapSize() {
        return 4;
    }
}

