/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class IntJavaType
extends PrimitiveWrapperJavaType {
    public String getTypeName() {
        return "INT";
    }

    public String getJavaTypeString() {
        return "int";
    }

    public String getJavaTypeStringPrimary() {
        return "Integer";
    }

    public String convertToObject(String name) {
        return "Integer.valueOf(" + name + ")";
    }

    public String convertToPrimitive(String name) {
        return name + ".intValue()";
    }

    public boolean isIntOrLong() {
        return true;
    }

    public int getSqlType() {
        return 4;
    }

    public String getSqlTypeAsString() {
        return "java.sql.Types.INTEGER";
    }

    public String getSqlDataType() {
        return "integer";
    }

    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForInt();
    }

    public String getDefaultInitialValue() {
        return "0";
    }

    public boolean isComparableTo(ASTLiteral node) {
        return node.isInteger();
    }

    public String getJavaTypeClass() {
        return "Integer.TYPE";
    }

    public String getArgumentForInOperation(String values, MithraObjectTypeWrapper fromObject) {
        return fromObject.getConstantIntSet(values);
    }

    public String getConnectionManagerClassName() {
        return "com.gs.fw.common.mithra.connectionmanager.IntSourceConnectionManager";
    }

    public boolean mayBeIdentity() {
        return true;
    }

    public int getOffHeapSize() {
        return 4;
    }
}

