/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.BeanState;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class LongJavaType
extends PrimitiveWrapperJavaType {
    public String getTypeName() {
        return "LONG";
    }

    public String getJavaTypeString() {
        return "long";
    }

    public String getJavaTypeStringPrimary() {
        return "Long";
    }

    public String convertToObject(String name) {
        return "new Long(" + name + ")";
    }

    public String convertToPrimitive(String name) {
        return name + ".longValue()";
    }

    public boolean isIntOrLong() {
        return true;
    }

    public int getSqlType() {
        return -5;
    }

    public String getSqlTypeAsString() {
        return "java.sql.Types.BIGINT";
    }

    public String getSqlDataType() {
        return "bigint";
    }

    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForLong();
    }

    public String getDefaultInitialValue() {
        return "0";
    }

    public boolean isComparableTo(ASTLiteral node) {
        return node.isInteger();
    }

    public String getJavaTypeClass() {
        return "Long.TYPE";
    }

    public boolean mayBeIdentity() {
        return true;
    }

    public String getBeanGetter(int intCount, int longCount, int objectCount) {
        return "getL" + longCount + "AsLong";
    }

    public boolean isBeanIntType() {
        return false;
    }

    public boolean isBeanLongType() {
        return true;
    }

    public String getBeanSetter(BeanState beanState) {
        return "setL" + beanState.getLongCount() + "AsLong";
    }

    public int getOffHeapSize() {
        return 8;
    }
}

