/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.PrimitiveWrapperJavaType;

public class ShortJavaType
extends PrimitiveWrapperJavaType {
    public String getTypeName() {
        return "SHORT";
    }

    public String getJavaTypeString() {
        return "short";
    }

    public String getJavaTypeStringPrimary() {
        return "Short";
    }

    public String convertToObject(String name) {
        return "new Short(" + name + ")";
    }

    public String convertToPrimitive(String name) {
        return name + ".shortValue()";
    }

    public int getSqlType() {
        return 5;
    }

    public String getSqlTypeAsString() {
        return "java.sql.Types.SMALLINT";
    }

    public String getSqlDataType() {
        return "smallint";
    }

    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForShortJava();
    }

    public String getDefaultInitialValue() {
        return "0";
    }

    public boolean isComparableTo(ASTLiteral node) {
        if (node.isInteger()) {
            int intValue = Integer.parseInt(node.getValue());
            return intValue >= Short.MIN_VALUE && intValue <= Short.MAX_VALUE;
        }
        return false;
    }

    public String getArgumentForInOperation(String values, MithraObjectTypeWrapper fromObject) {
        return fromObject.getConstantShortSet(values);
    }

    public String getJavaTypeClass() {
        return "Short.TYPE";
    }

    public String parseLiteralAndCast(String value) {
        return "(short)" + value;
    }

    public int getOffHeapSize() {
        return 2;
    }
}

