/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.type;

import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.queryparser.ASTLiteral;
import com.gs.fw.common.mithra.generator.type.DateJavaType;
import com.gs.fw.common.mithra.generator.type.JavaType;

public class TimestampJavaType
extends JavaType {
    public String getTypeName() {
        return "TIMESTAMP";
    }

    public String getJavaTypeString() {
        return "Timestamp";
    }

    public String getJavaTypeStringPrimary() {
        return "Timestamp";
    }

    public String getPrintableForm(String getter, String nullGetter, boolean isNullable) {
        return super.getPrintableForm(getter, nullGetter, true);
    }

    public String getPrintableForm(String getter) {
        return "PrintablePreparedStatement.timestampFormat.print(" + getter + ".getTime())";
    }

    public String getIoType() {
        return "Object";
    }

    public String getIoCast() {
        return "(Timestamp)";
    }

    public String convertToObject(String name) {
        return name;
    }

    public String convertToPrimitive(String name) {
        return name;
    }

    public boolean isPrimitive() {
        return false;
    }

    public int getSqlType() {
        return 93;
    }

    public String getSqlTypeAsString() {
        return "java.sql.Types.TIMESTAMP";
    }

    public String getSqlDataType() {
        return "datetime";
    }

    public String getSqlDataType(CommonDatabaseType databaseType, boolean nullable) {
        return databaseType.getSqlDataTypeForTimestamp();
    }

    public String getDefaultInitialValue() {
        return "null";
    }

    public boolean isComparableTo(ASTLiteral node) {
        return node.isString();
    }

    public boolean isComparableTo(JavaType other) {
        return other instanceof DateJavaType || other instanceof TimestampJavaType;
    }

    public String getJavaTypeClass() {
        return "Timestamp.class";
    }

    public String getObjectComparisonString(String obj1, String obj2) {
        return obj1 + ".equals(" + obj2 + ")";
    }

    public boolean isTimestamp() {
        return true;
    }

    public boolean canBePooled() {
        return true;
    }

    public int getOffHeapSize() {
        return 8;
    }
}

