/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.util;

import com.gs.fw.common.mithra.generator.util.AutoShutdownThreadExecutor;
import java.util.concurrent.atomic.AtomicInteger;

public class AwaitingThreadExecutor {
    private AutoShutdownThreadExecutor executor;
    private AtomicInteger todo = new AtomicInteger();

    public AwaitingThreadExecutor(int maxThreads, String name) {
        this.executor = new AutoShutdownThreadExecutor(maxThreads, name);
    }

    public void submit(Runnable task) {
        this.executor.submit(new CountingRunnable(task));
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public void setExceptionHandler(AutoShutdownThreadExecutor.ExceptionHandler exceptionHandler) {
        this.executor.setExceptionHandler(exceptionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDone() {
        AtomicInteger atomicInteger = this.todo;
        synchronized (atomicInteger) {
            while (this.todo.get() != 0 && !this.executor.isAborted()) {
                try {
                    this.todo.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class CountingRunnable
    implements Runnable {
        private Runnable target;

        private CountingRunnable(Runnable target) {
            this.target = target;
            AwaitingThreadExecutor.this.todo.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.target.run();
            }
            finally {
                int remaining = AwaitingThreadExecutor.this.todo.decrementAndGet();
                if (remaining == 0) {
                    AtomicInteger atomicInteger = AwaitingThreadExecutor.this.todo;
                    synchronized (atomicInteger) {
                        AwaitingThreadExecutor.this.todo.notify();
                    }
                }
            }
        }
    }
}

