/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.util;

import com.gs.fw.common.mithra.generator.util.SerialResource;
import java.util.concurrent.Semaphore;

public class ChopAndStickResource {
    private Semaphore cpuSemaphore;
    private Semaphore ioSemaphore;
    private SerialResource serialResource;

    public ChopAndStickResource(Semaphore cpuSemaphore, Semaphore ioSemaphore, SerialResource serialResource) {
        this.cpuSemaphore = cpuSemaphore;
        this.ioSemaphore = ioSemaphore;
        this.serialResource = serialResource;
    }

    public void acquireCpuResource() {
        this.acquireSemaphore(this.cpuSemaphore);
    }

    public void releaseCpuResource() {
        this.cpuSemaphore.release();
    }

    public void acquireIoResource() {
        this.acquireSemaphore(this.ioSemaphore);
    }

    public void releaseIoResource() {
        this.ioSemaphore.release();
    }

    public void acquireSerialResource(int resourceNumber) {
        this.serialResource.acquire(resourceNumber);
    }

    public void releaseSerialResource() {
        this.serialResource.release();
    }

    public void resetSerialResource() {
        this.serialResource.reset();
    }

    private void acquireSemaphore(Semaphore semaphore) {
        while (true) {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

