/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class StringUtility {
    public static String firstLetterToLower(String tmp) {
        return tmp.substring(0, 1).toLowerCase() + tmp.substring(1);
    }

    public static String firstLetterToUpper(String tmp) {
        return tmp.substring(0, 1).toUpperCase() + tmp.substring(1);
    }

    public static String removeLastCharacter(String tmp) {
        return StringUtility.removeLastCharacter(tmp, 1);
    }

    public static String removeLastCharacter(String tmp, int numberOfCharacters) {
        if (tmp.length() < numberOfCharacters) {
            return "";
        }
        return tmp.substring(0, tmp.length() - numberOfCharacters);
    }

    public static String trimPackage(String className) {
        return className.substring(className.lastIndexOf(46) + 1, className.length());
    }

    public static String replaceStr(String source, String pattern, String with) {
        if (pattern.length() == 0) {
            return source;
        }
        int i = 0;
        StringBuffer sb = new StringBuffer(source);
        do {
            if ((i = sb.toString().indexOf(pattern, i)) < 0) continue;
            sb.replace(i, i + pattern.length(), with);
            i += with.length();
        } while (i >= 0);
        return sb.toString();
    }

    public static boolean equalsIgnoreCaseFirstLetter(String aName, String bName) {
        if (aName.length() != bName.length()) {
            return false;
        }
        if (!aName.substring(0, 1).toUpperCase().equals(bName.substring(0, 1).toUpperCase())) {
            return false;
        }
        return aName.substring(1).compareToIgnoreCase(bName.substring(1)) == 0;
    }

    public static boolean vectorContainsIgnoreCaseFirstLetter(Vector v, String value) {
        for (int i = 0; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            if (!StringUtility.equalsIgnoreCaseFirstLetter(s, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean hashMapContainsKeyIgnoreCaseFirstLetter(HashMap hm, String value) {
        Set keys = hm.keySet();
        for (String key : keys) {
            if (!StringUtility.equalsIgnoreCaseFirstLetter(key, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean listContainsIgnoreCaseFirstLetter(List l, String value) {
        for (String key : l) {
            if (!StringUtility.equalsIgnoreCaseFirstLetter(key, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean arrayListContainsIgnoreCaseFirstLetter(ArrayList list, String value) {
        for (String key : list) {
            if (!StringUtility.equalsIgnoreCaseFirstLetter(key, value)) continue;
            return true;
        }
        return false;
    }

    public static String toCamelCaseIgnoringLastChar(String string, String delimiter, boolean upperFirst) {
        String trimmed = string.trim().replaceAll("(_)+", "$1");
        String[] delimited = delimiter.length() > 0 ? trimmed.split(delimiter) : new String[]{string};
        String result = "";
        for (int i = 0; i < delimited.length; ++i) {
            delimited[i] = StringUtility.toCamelCasePresevingExisting(delimited[i]);
            delimited[i] = i == 0 & !upperFirst ? StringUtility.firstLetterToLower(delimited[i]) : StringUtility.firstLetterToUpper(delimited[i]);
            if (delimited[i].length() == 1 && i == delimited.length - 1 && !Character.isDigit(delimited[i].charAt(0))) break;
            result = result + delimited[i];
        }
        return result;
    }

    public static String toCamelCasePresevingExisting(String s) {
        char[] result = new char[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            boolean uppercaseAllowed = i == 0 || Character.isLowerCase(s.charAt(i - 1));
            result[i] = s.charAt(i);
            if (uppercaseAllowed) continue;
            result[i] = Character.toLowerCase(result[i]);
        }
        return new String(result);
    }

    public static String englishPluralize(String tmp) {
        char last = tmp.charAt(tmp.length() - 1);
        if (last == 's' || last == 'x') {
            return tmp + "es";
        }
        if (last == 'y') {
            return tmp.substring(0, tmp.length() - 1) + "ies";
        }
        return tmp + 's';
    }

    public static String makeIntoJavaIdentifier(String tmp) {
        tmp = tmp.replace(" ", "");
        tmp = tmp.replace("_", "");
        tmp = tmp.replace("$", "");
        return StringUtility.toCamelCasePresevingExisting(tmp);
    }
}

