/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.zip.ZipOutputStream;

public class JarVersionCreator
extends Jar {
    private String applicationName;
    private String version;
    private CrcInputStream crcInputStream = new CrcInputStream();
    private List<FileChecksum> fileChecksums = new ArrayList<FileChecksum>(200);

    public void execute() throws BuildException {
        this.checkVersionAndName();
        super.execute();
    }

    private void checkVersionAndName() {
        this.checkName();
        if (this.version == null || this.version.trim().length() == 0) {
            throw new BuildException("version cannot be null or blank");
        }
    }

    protected void zipFile(InputStream is, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException {
        if (vPath.startsWith("META-INF/")) {
            if (!vPath.equals("META-INF/" + this.applicationName + ".crcver")) {
                super.zipFile(is, zOut, vPath, lastModified, fromArchive, mode);
            }
        } else {
            this.crcInputStream.resetStream(is);
            super.zipFile((InputStream)this.crcInputStream, zOut, vPath, lastModified, fromArchive, mode);
            this.fileChecksums.add(new FileChecksum(vPath, this.crcInputStream.getCrcValue()));
        }
    }

    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        this.createVersionInfo(zOut);
        super.finalizeZipOutputStream(zOut);
    }

    private void createVersionInfo(ZipOutputStream zOut) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF8"));
        CRC32 fullCrc = new CRC32();
        writer.print("name: ");
        writer.println(this.applicationName);
        writer.print("version: ");
        writer.println(this.version);
        fullCrc.update(this.applicationName.getBytes("UTF8"));
        fullCrc.update(this.version.getBytes("UTF8"));
        this.writeVersionInfo(writer, fullCrc);
        writer.println();
        writer.print(":crc: ");
        writer.println(Long.toHexString(fullCrc.getValue()));
        if (writer.checkError()) {
            throw new IOException("Encountered an error writing jar version information");
        }
        writer.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile((InputStream)bais, zOut, "META-INF/" + this.applicationName + ".crcver", System.currentTimeMillis(), null, 33188);
        bais.close();
    }

    private void writeVersionInfo(PrintWriter writer, CRC32 fullCrc) throws IOException {
        if (this.fileChecksums.size() == 0) {
            return;
        }
        Collections.sort(this.fileChecksums);
        String currentPackage = null;
        for (int i = 0; i < this.fileChecksums.size(); ++i) {
            String vPath = this.fileChecksums.get(i).vPath;
            fullCrc.update(vPath.getBytes("UTF8"));
            currentPackage = this.writePackage(writer, currentPackage, vPath);
            String filename = vPath.substring(currentPackage.length());
            writer.print(filename);
            writer.print(": ");
            String crc = Long.toHexString(this.fileChecksums.get(i).crc);
            writer.println(crc);
            fullCrc.update(crc.getBytes("UTF8"));
        }
    }

    private String writePackage(PrintWriter writer, String currentPackage, String vPath) {
        String newPackage = this.getDir(vPath);
        if (currentPackage == null || !currentPackage.equals(newPackage)) {
            writer.print("/");
            writer.println(newPackage);
        }
        return newPackage;
    }

    private String getDir(String vPath) {
        int index = vPath.lastIndexOf(47);
        if (index < 0) {
            return "";
        }
        return vPath.substring(0, index + 1);
    }

    protected void cleanUp() {
        super.cleanUp();
        this.fileChecksums.clear();
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setAppName(String applicationName) {
        this.applicationName = applicationName;
    }

    private void checkName() {
        if (this.applicationName == null || this.applicationName.trim().length() == 0) {
            throw new BuildException("application name cannot be null");
        }
        if (!this.applicationName.toLowerCase().equals(this.applicationName)) {
            throw new BuildException("application name must be all lowercase");
        }
        if (this.applicationName.contains(" ")) {
            throw new BuildException("application name must not have spaces");
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private static class FileChecksum
    implements Comparable {
        private String vPath;
        private long crc;

        private FileChecksum(String vPath, long crc) {
            this.vPath = vPath;
            this.crc = crc;
        }

        public int compareTo(Object o) {
            return this.vPath.compareTo(((FileChecksum)o).vPath);
        }
    }

    private static class CrcInputStream
    extends InputStream {
        private InputStream in;
        private CRC32 crc32 = new CRC32();

        private CrcInputStream() {
        }

        @Override
        public int read() throws IOException {
            int result = this.in.read();
            if (result != -1) {
                this.crc32.update(result);
            }
            return result;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int result = this.in.read(b);
            if (result > 0) {
                this.crc32.update(b, 0, result);
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.in.read(b, off, len);
            if (result > 0) {
                this.crc32.update(b, off, result);
            }
            return result;
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        public void resetStream(InputStream in) {
            this.in = in;
            this.crc32.reset();
        }

        public long getCrcValue() {
            return this.crc32.getValue();
        }
    }
}

