/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import com.gs.fw.common.mithra.generator.BaseMithraGenerator;
import com.gs.fw.common.mithra.generator.GenerationLog;
import com.gs.fw.common.mithra.generator.GenerationLogger;
import com.gs.fw.common.mithra.generator.Logger;
import com.gs.fw.common.mithra.generator.MithraEmbeddedValueObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.MithraGeneratorImport;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.metamodel.MithraInterfaceType;
import com.gs.fw.common.mithra.generator.util.AwaitingThreadExecutor;
import com.gs.fw.common.mithra.generator.util.ChopAndStickResource;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class AbstractMithraGenerator
extends Task
implements Logger,
GenerationLogger {
    public static final String DATED = "dated";
    public static final String READ_ONLY = "read-only";
    public static final String DATED_READ_ONLY = "datedread-only";
    public static final String TRANSACTIONAL = "transactional";
    public static final String DATED_TRANSACTIONAL = "datedtransactional";
    public static final String EMBEDDED_VALUE = "embedded-value";
    public static final String ENUMERATION = "enumeration";
    public static final String MITHRA_INTERFACE = "mithra-interface";
    private int logLevel = 1;
    protected GenerationLog oldGenerationLog;
    protected GenerationLog newGenerationLog;
    private StringBuilder errorLogs = new StringBuilder();
    protected BaseMithraGenerator baseGenerator;

    protected AbstractMithraGenerator() {
        this(new BaseMithraGenerator());
    }

    protected AbstractMithraGenerator(BaseMithraGenerator gen) {
        this.baseGenerator = gen;
        this.baseGenerator.setLogger(this);
        this.baseGenerator.setGenerationLogger(this);
    }

    public void setIgnorePackageNamingConvention(boolean ignorePackageNamingConvention) {
        this.baseGenerator.setIgnorePackageNamingConvention(ignorePackageNamingConvention);
    }

    public void setForceOffHeap(boolean forceOffHeap) {
        this.baseGenerator.setForceOffHeap(forceOffHeap);
    }

    protected String getMd5() {
        return this.baseGenerator.getMd5();
    }

    protected String getCrc() {
        return this.baseGenerator.getCrc();
    }

    protected List<MithraGeneratorImport> getImports() {
        return this.baseGenerator.getImports();
    }

    public String getXml() {
        return this.baseGenerator.getXml();
    }

    public void setXml(String xml) {
        this.baseGenerator.setXml(xml);
    }

    @Override
    public GenerationLog getOldGenerationLog() {
        return this.oldGenerationLog;
    }

    @Override
    public GenerationLog getNewGenerationLog() {
        return this.newGenerationLog;
    }

    @Override
    public void setOldGenerationLog(GenerationLog log) {
        this.oldGenerationLog = log;
    }

    @Override
    public void setNewGenerationLog(GenerationLog log) {
        this.newGenerationLog = log;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public String getGeneratedDir() {
        return this.baseGenerator.getGeneratedDir();
    }

    public void setGeneratedDir(String generatedDir) {
        this.baseGenerator.setGeneratedDir(generatedDir);
    }

    public String getNonGeneratedDir() {
        return this.baseGenerator.getNonGeneratedDir();
    }

    public void setNonGeneratedDir(String nonGeneratedDir) {
        this.baseGenerator.setNonGeneratedDir(nonGeneratedDir);
    }

    public void setIgnoreNonGeneratedAbstractClasses(boolean ignoreNonGeneratedAbstractClasses) {
        this.baseGenerator.setIgnoreNonGeneratedAbstractClasses(ignoreNonGeneratedAbstractClasses);
    }

    public void setIgnoreTransactionalMethods(boolean ignoreTransactionalMethods) {
        this.baseGenerator.setIgnoreTransactionalMethods(ignoreTransactionalMethods);
    }

    public boolean isDefaultFinalGetters() {
        return this.baseGenerator.isDefaultFinalGetters();
    }

    public void setDefaultFinalGetters(boolean defaultFinalGetters) {
        this.baseGenerator.setDefaultFinalGetters(defaultFinalGetters);
    }

    public Map<String, MithraObjectTypeWrapper> getMithraObjects() {
        return this.baseGenerator.getMithraObjects();
    }

    public Map<String, MithraEmbeddedValueObjectTypeWrapper> getMithraEmbeddedValueObjects() {
        return this.baseGenerator.getMithraEmbeddedValueObjects();
    }

    public Map<String, MithraInterfaceType> getMithraInterfaces() {
        return this.baseGenerator.getMithraInterfaces();
    }

    protected boolean extractMithraInterfaceRelationshipsAndSuperInterfaces() {
        return this.baseGenerator.extractMithraInterfaceRelationshipsAndSuperInterfaces();
    }

    protected void validateXml() {
        boolean mithraInterfaceSuccess = this.extractMithraInterfaceRelationshipsAndSuperInterfaces();
        boolean mithraEmbeddedValueObjectXmlSuccess = this.baseGenerator.validateMithraEmbeddedValueObjectXml();
        boolean mithraObjectXmlSuccess = this.baseGenerator.validateMithraObjectXml();
        if (!(mithraInterfaceSuccess && mithraEmbeddedValueObjectXmlSuccess && mithraObjectXmlSuccess)) {
            String errors = this.errorLogs.toString();
            this.errorLogs.setLength(0);
            throw new BuildException("One or more error(s) while validating mithra xml\n" + errors);
        }
    }

    public MithraGeneratorImport createMithraImport() {
        return new MithraGeneratorImport();
    }

    public void addConfiguredMithraImport(MithraGeneratorImport importElement) {
        this.baseGenerator.addConfiguredMithraImport(importElement);
    }

    public abstract void execute() throws BuildException;

    public void log(String s, int level) {
        super.log(s, level);
        if (level == 0) {
            this.errorLogs.append(s).append("\n");
        }
    }

    private void logForLevel(String msg, int level) {
        if (this.logLevel >= level) {
            this.log(msg, level);
        }
    }

    private void logForLevel(String msg, Throwable t, int level) {
        if (this.logLevel >= level) {
            this.log(msg + ": " + t.getClass().getName() + ": " + t.getMessage(), level);
        }
    }

    @Override
    public void info(String msg) {
        this.logForLevel(msg, 2);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.logForLevel(msg, t, 2);
    }

    @Override
    public void warn(String msg) {
        this.logForLevel(msg, 1);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.logForLevel(msg, t, 1);
    }

    @Override
    public void error(String msg) {
        this.logForLevel(msg, 0);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.logForLevel(msg, t, 0);
    }

    @Override
    public void debug(String msg) {
        this.logForLevel(msg, 4);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.logForLevel(msg, t, 4);
    }

    public StringBuilder getErrorLogs() {
        return this.errorLogs;
    }

    public ChopAndStickResource getChopAndStickResource() {
        return this.baseGenerator.getChopAndStickResource();
    }

    public AwaitingThreadExecutor getExecutor() {
        return this.baseGenerator.getExecutor();
    }

    protected abstract class GeneratorTask
    implements Runnable {
        private int resourceNumber;

        protected GeneratorTask(int resourceNumber) {
            this.resourceNumber = resourceNumber;
        }

        public void acquireSerialResource() {
            AbstractMithraGenerator.this.getChopAndStickResource().acquireSerialResource(this.resourceNumber);
        }

        public void releaseSerialResource() {
            AbstractMithraGenerator.this.getChopAndStickResource().releaseSerialResource();
        }
    }
}

