/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import java.util.HashMap;

public abstract class Cardinality {
    private static final Cardinality ONE_TO_MANY = new Cardinality(){

        @Override
        public boolean isToMany() {
            return true;
        }

        @Override
        public boolean isFromMany() {
            return false;
        }

        @Override
        public Cardinality getReverseCardinality() {
            return MANY_TO_ONE;
        }

        @Override
        public String getNameAsClassName() {
            return "OneToMany";
        }
    };
    private static final Cardinality MANY_TO_MANY = new Cardinality(){

        @Override
        public boolean isToMany() {
            return true;
        }

        @Override
        public boolean isFromMany() {
            return true;
        }

        @Override
        public Cardinality getReverseCardinality() {
            return MANY_TO_MANY;
        }

        @Override
        public String getNameAsClassName() {
            return "ManyToMany";
        }
    };
    private static final Cardinality ONE_TO_ONE = new Cardinality(){

        @Override
        public boolean isToMany() {
            return false;
        }

        @Override
        public boolean isFromMany() {
            return false;
        }

        @Override
        public Cardinality getReverseCardinality() {
            return ONE_TO_ONE;
        }

        @Override
        public String getNameAsClassName() {
            return "OneToOne";
        }
    };
    private static final Cardinality MANY_TO_ONE = new Cardinality(){

        @Override
        public boolean isToMany() {
            return false;
        }

        @Override
        public boolean isFromMany() {
            return true;
        }

        @Override
        public Cardinality getReverseCardinality() {
            return ONE_TO_MANY;
        }

        @Override
        public String getNameAsClassName() {
            return "ManyToOne";
        }
    };
    private static HashMap enumMap = new HashMap();

    private Cardinality() {
    }

    public abstract boolean isToMany();

    public abstract boolean isFromMany();

    public abstract Cardinality getReverseCardinality();

    public abstract String getNameAsClassName();

    public boolean isManyToMany() {
        return this.isFromMany() && this.isToMany();
    }

    public static Cardinality getByName(String name) {
        return (Cardinality)enumMap.get(name);
    }

    static {
        enumMap.put("one-to-many", ONE_TO_MANY);
        enumMap.put("many-to-many", MANY_TO_MANY);
        enumMap.put("one-to-one", ONE_TO_ONE);
        enumMap.put("many-to-one", MANY_TO_ONE);
    }
}

