/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import com.gs.fw.common.mithra.generator.CoreMithraGenerator;
import com.gs.fw.common.mithra.generator.MithraGeneratorException;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.RelationshipAttribute;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class CoreMithraUmlGenerator
extends CoreMithraGenerator {
    private String outputFile;

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public void execute() {
        try {
            this.parseAndValidate();
            OutputStream fos = this.fauxFileSystem.newFile(this.getOutputFile()).newFileOutputStream();
            PrintWriter writer = new PrintWriter(fos);
            for (MithraObjectTypeWrapper mithraObjectTypeWrapper : this.getSortedMithraObjects()) {
                writer.write("/**\n");
                RelationshipAttribute[] relationshipAttributes = mithraObjectTypeWrapper.getRelationshipAttributes();
                for (int i = 0; i < relationshipAttributes.length; ++i) {
                    writer.write("* @");
                    if (relationshipAttributes[i].isRelatedDependent()) {
                        writer.write("composed ");
                    } else {
                        writer.write("assoc ");
                    }
                    if (relationshipAttributes[i].getCardinality().isFromMany()) {
                        writer.write("* ");
                    } else {
                        writer.write("1 ");
                    }
                    writer.write(relationshipAttributes[i].getName());
                    if (relationshipAttributes[i].getCardinality().isToMany()) {
                        writer.write(" * ");
                    } else {
                        writer.write(" 1 ");
                    }
                    writer.write(relationshipAttributes[i].getRelatedObject().getClassName());
                    writer.write("\n");
                }
                writer.write("*/\n");
                writer.write("public class " + mithraObjectTypeWrapper.getClassName());
                if (mithraObjectTypeWrapper.getSuperClassWrapper() != null) {
                    writer.write(" extends ");
                    writer.write(mithraObjectTypeWrapper.getSuperClassWrapper().getClassName());
                }
                writer.write(" {}\n\n");
            }
            writer.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            throw new MithraGeneratorException("could not find file", e);
        }
        catch (IOException e) {
            throw new MithraGeneratorException("could not write file", e);
        }
    }
}

