/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import com.gs.fw.common.mithra.generator.filesystem.GeneratedFileManager;
import com.gs.fw.common.mithra.generator.util.StringUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.concurrent.atomic.AtomicInteger;

public class GenerationLog {
    private String md5;
    private String xmlCrc;

    public GenerationLog(String md5, String xmlCrc) {
        this.md5 = md5;
        this.xmlCrc = xmlCrc;
    }

    public String getMd5() {
        return this.md5;
    }

    public String getXmlCrc() {
        return this.xmlCrc;
    }

    public void writeLog(String generatedDir, GeneratedFileManager fileManager, String classListName) throws IOException {
        String logNameFromClassListName = GenerationLog.getLogNameFromClassListName(generatedDir, classListName);
        System.out.println("writing log to " + logNameFromClassListName + ".log");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        OutputStreamWriter writer = new OutputStreamWriter(baos);
        writer.write(this.md5 + "\n");
        writer.write(this.xmlCrc + "\n");
        writer.close();
        fileManager.writeFile(true, "", logNameFromClassListName, ".log", baos.toByteArray(), new AtomicInteger());
    }

    private static String getLogNameFromClassListName(String generatedDir, String classListName) {
        String cleanedGeneratedDir = GenerationLog.getCleanedDir(generatedDir);
        String cleanedClassListName = GenerationLog.getCleanedDir(classListName);
        int maxSearchLength = cleanedGeneratedDir.length();
        if (cleanedClassListName.length() < maxSearchLength) {
            maxSearchLength = cleanedClassListName.length();
        }
        int matchedCharIndex = 0;
        for (int i = 0; i < maxSearchLength && Character.toUpperCase(cleanedClassListName.charAt(i)) == Character.toUpperCase(cleanedGeneratedDir.charAt(i)); ++i) {
            ++matchedCharIndex;
        }
        return cleanedClassListName.substring(matchedCharIndex, cleanedClassListName.length());
    }

    private static String getCleanedDir(String generatedDir) {
        String cleanedGeneratedDir = StringUtility.replaceStr(generatedDir, "/", ".");
        cleanedGeneratedDir = StringUtility.replaceStr(cleanedGeneratedDir, "\\", ".");
        cleanedGeneratedDir = StringUtility.replaceStr(cleanedGeneratedDir, File.separator, ".");
        cleanedGeneratedDir = StringUtility.replaceStr(cleanedGeneratedDir, ":", ".");
        return cleanedGeneratedDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GenerationLog readOldLog(String generatedDir, String fileNameForClassList, GeneratedFileManager fileManager) throws IOException {
        GenerationLog result = new GenerationLog("xxx", "00");
        byte[] bytes = fileManager.readFileInGeneratedDir(GenerationLog.getLogNameFromClassListName(generatedDir, fileNameForClassList) + ".log");
        if (bytes != null) {
            try (ByteArrayInputStream fis = new ByteArrayInputStream(bytes);){
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(fis));
                String md5 = reader.readLine();
                String xmlCrc = reader.readLine();
                if (md5 != null && xmlCrc != null) {
                    result = new GenerationLog(md5, xmlCrc);
                }
            }
        }
        return result;
    }

    public boolean isSame(GenerationLog oldLog) {
        return this.getMd5().equals(oldLog.getMd5()) && this.getXmlCrc().equals(oldLog.getXmlCrc());
    }
}

