/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import com.gs.fw.common.mithra.generator.AbstractAttribute;
import com.gs.fw.common.mithra.generator.AsOfAttribute;
import com.gs.fw.common.mithra.generator.Attribute;
import com.gs.fw.common.mithra.generator.BeanState;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.metamodel.IndexType;
import com.gs.fw.common.mithra.generator.util.StringUtility;
import java.util.ArrayList;
import java.util.List;

public class Index {
    private Attribute[] attributes;
    private String[] unresolvedAttributes;
    private String name;
    private boolean unique;
    private boolean pkStatus = false;
    private boolean isSameAsPk;
    private Index sameIndex = null;
    private MithraObjectTypeWrapper wrapper;

    public Index(Attribute[] attributes, String name, boolean unique, MithraObjectTypeWrapper wrapper) {
        this.attributes = attributes;
        this.name = name;
        this.unique = unique;
        this.wrapper = wrapper;
    }

    public void setPkStatus(boolean pkStatus) {
        this.pkStatus = pkStatus;
    }

    public boolean isPk() {
        return this.pkStatus;
    }

    public Index(IndexType indexType, MithraObjectTypeWrapper wrapper) {
        this.name = indexType.getName();
        this.unique = indexType.isUnique();
        this.wrapper = wrapper;
        String[] attributeNames = indexType.value().split(", *");
        ArrayList<Attribute> good = new ArrayList<Attribute>();
        ArrayList<String> bad = new ArrayList<String>();
        for (int i = 0; i < attributeNames.length; ++i) {
            if (attributeNames[i].length() <= 0) continue;
            Attribute a = wrapper.getAttributeByName(attributeNames[i].trim());
            if (a == null) {
                bad.add(attributeNames[i]);
                continue;
            }
            good.add(a);
        }
        if (wrapper.hasSourceAttribute() && this.isUnique()) {
            good.add(wrapper.getSourceAttribute());
        }
        this.attributes = new Attribute[good.size()];
        good.toArray(this.attributes);
        this.unresolvedAttributes = new String[bad.size()];
        bad.toArray(this.unresolvedAttributes);
    }

    public AbstractAttribute[] getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIndexColumns() {
        String result = "";
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i].isSourceAttribute()) continue;
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + this.attributes[i].getColumnName();
        }
        return result;
    }

    public ArrayList<String> getIndexColumnsNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i].isSourceAttribute()) continue;
            names.add(this.attributes[i].getColumnName());
        }
        return names;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void checkConsistency(List<String> errors) {
        for (int i = 0; i < this.unresolvedAttributes.length; ++i) {
            errors.add("Could not resolve attribute " + this.unresolvedAttributes[i] + " for index " + this.name);
        }
    }

    public boolean isRedundantIndex(List attributes) {
        int i;
        ArrayList copy = new ArrayList(attributes);
        for (i = 0; i < this.attributes.length; ++i) {
            copy.remove(this.attributes[i]);
        }
        if (copy.size() == 0 && attributes.size() == this.attributes.length) {
            return true;
        }
        if (this.isUnique()) {
            if (this.attributes.length != attributes.size()) {
                return false;
            }
            for (i = 0; i < this.attributes.length; ++i) {
                if (attributes.contains(this.attributes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasFastPathLookup() {
        BeanState beanState = new BeanState();
        for (int i = 0; i < this.attributes.length; ++i) {
            beanState.increment(this.attributes[i]);
        }
        return beanState.getIntCount() <= 4 && beanState.getLongCount() <= 4 && beanState.getObjectCount() <= 4;
    }

    public String getSanitizedUpperCaseName() {
        String result = StringUtility.makeIntoJavaIdentifier(this.name);
        if (result.startsWith("by") && result.length() > 2) {
            result = result.substring(2);
        }
        return StringUtility.firstLetterToUpper(result);
    }

    public String getFindByParameters() {
        String result = this.attributes[0].getType().getJavaTypeString() + " " + this.attributes[0].getName();
        for (int i = 1; i < this.attributes.length; ++i) {
            result = result + ", " + this.attributes[i].getType().getJavaTypeString() + " " + this.attributes[i].getName();
        }
        if (this.wrapper.hasAsOfAttributes()) {
            AsOfAttribute[] asOfAttributes;
            for (AsOfAttribute attr : asOfAttributes = this.wrapper.getAsOfAttributes()) {
                result = result + ", Timestamp " + attr.getName();
            }
        }
        return result;
    }

    public String getFindByVariables() {
        String result = this.attributes[0].getName();
        for (int i = 1; i < this.attributes.length; ++i) {
            result = result + ", " + this.attributes[i].getName();
        }
        if (this.wrapper.hasAsOfAttributes()) {
            AsOfAttribute[] asOfAttributes;
            for (AsOfAttribute attr : asOfAttributes = this.wrapper.getAsOfAttributes()) {
                result = result + ", " + attr.getName();
            }
        }
        return result;
    }

    public String getBeanType() {
        return "I3O3L3";
    }

    public String getLookupEqualsCondition() {
        BeanState beanState = new BeanState();
        String beanAttribute = "_bean." + this.attributes[0].getBeanGetter(beanState.getIntCount(), beanState.getLongCount(), beanState.getObjectCount()) + "()";
        String result = this.attributes[0].getType().isPrimitive() ? beanAttribute + " == _castedTargetData." + this.attributes[0].getGetter() + "()" : (this.attributes[0].isArray() ? "Arrays.equals(" + beanAttribute + ", _castedTargetData." + this.attributes[0].getGetter() + "())" : beanAttribute + ".equals(_castedTargetData." + this.attributes[0].getGetter() + "())");
        beanState.increment(this.attributes[0]);
        for (int i = 1; i < this.attributes.length; ++i) {
            beanAttribute = "_bean." + this.attributes[i].getBeanGetter(beanState.getIntCount(), beanState.getLongCount(), beanState.getObjectCount()) + "()";
            result = this.attributes[i].getType().isPrimitive() ? result + " && " + beanAttribute + " == _castedTargetData." + this.attributes[i].getGetter() + "()" : (this.attributes[i].isArray() ? result + " && Arrays.equals(" + beanAttribute + ", _castedTargetData." + this.attributes[i].getGetter() + "())" : result + " && " + beanAttribute + ".equals(_castedTargetData." + this.attributes[i].getGetter() + "())");
            beanState.increment(this.attributes[i]);
        }
        return result;
    }

    public String getAsOfAttributeCheckCondition() {
        if (this.wrapper.hasAsOfAttributes()) {
            AsOfAttribute[] asOfAttributes = this.wrapper.getAsOfAttributes();
            String result = this.wrapper.getFinderClassName() + "." + asOfAttributes[0].getName() + "().dataMatches(_castedTargetData, _asOfDate0)";
            if (asOfAttributes.length == 2) {
                result = result + " && " + this.wrapper.getFinderClassName() + "." + asOfAttributes[1].getName() + "().dataMatches(_castedTargetData, _asOfDate1)";
            }
            return result;
        }
        return "true";
    }

    public String getLookupHashCompute(boolean offHeap) {
        BeanState beanState = new BeanState();
        String result = this.addHashCodeExpression(null, this.attributes[0], beanState, offHeap);
        beanState.increment(this.attributes[0]);
        for (int i = 1; i < this.attributes.length; ++i) {
            result = this.addHashCodeExpression(result, this.attributes[i], beanState, offHeap);
            beanState.increment(this.attributes[i]);
        }
        return result;
    }

    private String addHashCodeExpression(String result, AbstractAttribute uniqueAttribute, BeanState beanState, boolean offHeap) {
        boolean combine = false;
        String hashMethod = "hash";
        if (uniqueAttribute.isStringAttribute() && offHeap) {
            hashMethod = "offHeapHash";
        }
        if (result != null) {
            combine = true;
            result = "HashUtil.combineHashes(" + result + ",HashUtil." + hashMethod + "(";
        } else {
            result = "HashUtil." + hashMethod + "(";
        }
        result = result + "_bean." + uniqueAttribute.getBeanGetter(beanState.getIntCount(), beanState.getLongCount(), beanState.getObjectCount());
        result = result + "())";
        if (combine) {
            result = result + ")";
        }
        return result;
    }

    public String getLookupNotNullCheck() {
        String result = "";
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i].isPrimitive()) continue;
            if (result.length() > 0) {
                result = result + " && ";
            }
            result = result + this.attributes[i].getName() + " != null";
        }
        if (result.length() > 0) {
            result = "if (" + result + ")";
        }
        return result;
    }

    public String getLookupBeanSetters() {
        String result = "";
        BeanState beanState = new BeanState();
        for (int i = 0; i < this.attributes.length; ++i) {
            result = result + "\n";
            result = result + "_bean." + this.attributes[i].getBeanSetter(beanState) + "(" + this.attributes[i].getName() + ");";
            beanState.increment(this.attributes[i]);
        }
        return result;
    }

    public String getLookupCacheParameters() {
        String result = "_bean, _bean, for" + this.getSanitizedUpperCaseName() + ", ";
        if (this.wrapper.hasAsOfAttributes()) {
            AsOfAttribute[] asOfAttributes = this.wrapper.getAsOfAttributes();
            result = result + asOfAttributes[0].getName();
            result = result + ", ";
            result = asOfAttributes.length == 2 ? result + asOfAttributes[1].getName() : result + "null";
        } else {
            result = result + "null, null";
        }
        if (!this.isPk()) {
            result = result + ", " + this.wrapper.getFinderClassName() + ".zGetIndex" + this.getName() + "Ref()";
        }
        return result;
    }

    public String getLookupOperation() {
        String result = "this." + this.attributes[0].getName() + "().eq(" + this.attributes[0].getName() + ")";
        for (int i = 1; i < this.attributes.length; ++i) {
            result = result + ".and(this." + this.attributes[i].getName() + "().eq(" + this.attributes[i].getName() + "))";
        }
        if (this.wrapper.hasAsOfAttributes()) {
            AsOfAttribute[] asOfAttributes;
            for (AsOfAttribute attr : asOfAttributes = this.wrapper.getAsOfAttributes()) {
                result = result + ".and(this." + attr.getName() + "().eq(" + attr.getName() + "))";
            }
        }
        return result;
    }

    public String getCacheLookupMethod() {
        if (this.isPk()) {
            return "getAsOneFromCache";
        }
        return "getAsOneByIndexFromCache";
    }

    public boolean isSameAsPk() {
        return this.isSameAsPk;
    }

    public void setIsSameAsPk(boolean isSameAsPk) {
        this.isSameAsPk = isSameAsPk;
    }

    public void setSameIndex(Index index) {
        this.sameIndex = index;
    }

    public Index getSameIndex() {
        return this.sameIndex;
    }
}

