/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import com.gs.fw.common.mithra.generator.CommonWrapper;
import com.gs.fw.common.mithra.generator.JspWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MithraSuperTypeWrapper
implements CommonWrapper {
    private static Map<String, StringBuilder> abstractTemplateCache = new HashMap<String, StringBuilder>();
    private String packageName;
    private String superClass;
    private String className;
    private boolean isDated;
    private Set<String> imports;
    private boolean isWritten;

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    public boolean hasSuperClass() {
        return this.superClass != null;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public String getFullyQualifiedSuperClassType() {
        return this.superClass;
    }

    public String getMithraInterfaceName() {
        if (this.isDated) {
            return "MithraDatedTransactionalObject";
        }
        return "MithraTransactionalObject";
    }

    public void writeAbstractTemplate(JspWriter out, String templateSection) throws IOException {
        StringBuilder template = new StringBuilder(this.getCachedAbstractTemplate(templateSection));
        String toReplace = "MithraTransactionalObjectImpl";
        if (this.isDated) {
            toReplace = "MithraDatedTransactionalObjectImpl";
        }
        int pos = template.indexOf(toReplace);
        while (pos >= 0) {
            template.replace(pos, toReplace.length() + pos, this.getClassName());
            pos = template.indexOf(toReplace);
        }
        out.write(template.toString());
    }

    private StringBuilder getCachedAbstractTemplate(String templateSection) {
        String templateName = "com/gs/fw/common/mithra/generator/";
        if (this.isDated) {
            templateName = templateName + "Dated";
        }
        templateName = templateName + "Transactional";
        StringBuilder builder = abstractTemplateCache.get(templateName = templateName + ".tmpl." + templateSection);
        if (builder == null) {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(templateName);
            builder = new StringBuilder();
            byte[] buf = new byte[1024];
            if (is != null) {
                try {
                    int read;
                    while ((read = is.read(buf)) >= 0) {
                        builder.append(new String(buf, 0, read));
                    }
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("could not read template " + templateName, e);
                }
            } else {
                throw new RuntimeException("The template " + templateName + " is missing from the classpath");
            }
            abstractTemplateCache.put(templateName, builder);
        }
        return builder;
    }

    public String getFullyQualifiedClassName() {
        return this.packageName + "." + this.className;
    }

    public void setClassName(String className) {
        if (className.indexOf(46) >= 0) {
            this.className = className.substring(className.lastIndexOf(46) + 1);
            this.packageName = className.substring(0, className.lastIndexOf(46));
        } else {
            this.className = className;
        }
    }

    public void setSuperClass(String fullyQualifiedSuperClassType) {
        this.superClass = fullyQualifiedSuperClassType;
    }

    public void setDated(boolean isDated) {
        this.isDated = isDated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MithraSuperTypeWrapper that = (MithraSuperTypeWrapper)o;
        if (!this.className.equals(that.className)) {
            return false;
        }
        return !(this.packageName != null ? !this.packageName.equals(that.packageName) : that.packageName != null);
    }

    public int hashCode() {
        int result = this.packageName != null ? this.packageName.hashCode() : 0;
        result = 31 * result + this.className.hashCode();
        return result;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public boolean isWritten() {
        return this.isWritten;
    }

    public void setWritten(boolean written) {
        this.isWritten = written;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public void setImports(Set<String> imports) {
        this.imports = imports;
    }
}

