/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import com.gs.fw.common.mithra.generator.Logger;
import com.gs.fw.common.mithra.generator.MithraEmbeddedValueObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.MithraGeneratorException;
import com.gs.fw.common.mithra.generator.MithraObjectTypeParser;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.filesystem.DirectoryFileProvider;
import com.gs.fw.common.mithra.generator.filesystem.FauxFile;
import com.gs.fw.common.mithra.generator.filesystem.FauxFileSystem;
import com.gs.fw.common.mithra.generator.filesystem.FileInputStreamWithSize;
import com.gs.fw.common.mithra.generator.filesystem.FileProvider;
import com.gs.fw.common.mithra.generator.metamodel.MithraBaseObjectType;
import com.gs.fw.common.mithra.generator.metamodel.MithraEmbeddedValueObjectResourceType;
import com.gs.fw.common.mithra.generator.metamodel.MithraEmbeddedValueObjectType;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorParserException;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorUnmarshaller;
import com.gs.fw.common.mithra.generator.metamodel.MithraInterfaceResourceType;
import com.gs.fw.common.mithra.generator.metamodel.MithraInterfaceType;
import com.gs.fw.common.mithra.generator.metamodel.MithraObjectResourceType;
import com.gs.fw.common.mithra.generator.metamodel.MithraPureObjectResourceType;
import com.gs.fw.common.mithra.generator.metamodel.MithraTempObjectResourceType;
import com.gs.fw.common.mithra.generator.metamodel.MithraType;
import com.gs.fw.common.mithra.generator.util.AutoShutdownThreadExecutor;
import com.gs.fw.common.mithra.generator.util.AwaitingThreadExecutor;
import com.gs.fw.common.mithra.generator.util.ChopAndStickResource;
import com.gs.fw.common.mithra.generator.util.FullFileBuffer;
import com.gs.fw.common.mithra.generator.util.SerialResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.zip.CRC32;

public class MithraXMLObjectTypeParser
implements MithraObjectTypeParser {
    protected String mithraClassListXml;
    private CRC32 crc32 = new CRC32();
    private static final int IO_THREADS = 1;
    private AwaitingThreadExecutor executor;
    private Throwable executorError;
    private ChopAndStickResource chopAndStickResource = new ChopAndStickResource(new Semaphore(Runtime.getRuntime().availableProcessors()), new Semaphore(1), new SerialResource());
    private Map<String, MithraObjectTypeWrapper> mithraObjects = new ConcurrentHashMap<String, MithraObjectTypeWrapper>();
    private List<MithraObjectTypeWrapper> sortedMithraObjects;
    private Map<String, MithraEmbeddedValueObjectTypeWrapper> mithraEmbeddedValueObjects = new ConcurrentHashMap<String, MithraEmbeddedValueObjectTypeWrapper>();
    private List<MithraEmbeddedValueObjectTypeWrapper> sortedMithraEmbeddedValueObjects;
    private Map<String, MithraInterfaceType> mithraInterfaces = new ConcurrentHashMap<String, MithraInterfaceType>();
    private boolean generateFileHeaders = false;
    private boolean ignoreNonGeneratedAbstractClasses = false;
    private boolean ignoreTransactionalMethods = false;
    private boolean ignorePackageNamingConvention = false;
    private boolean defaultFinalGetters = false;
    private boolean forceOffHeap = false;
    protected FauxFileSystem fauxFileSystem;
    private ThreadLocal<FullFileBuffer> fullFileBufferThreadLocal = new ThreadLocal();
    private Logger logger;

    public MithraXMLObjectTypeParser(String mithraClassListXml) {
        this.mithraClassListXml = mithraClassListXml;
    }

    public void setMithraClassListXml(String mithraClassListXml) {
        this.mithraClassListXml = mithraClassListXml;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void setForceOffHeap(boolean forceOffHeap) {
        this.forceOffHeap = forceOffHeap;
    }

    @Override
    public void setDefaultFinalGetters(boolean defaultFinalGetters) {
        this.defaultFinalGetters = defaultFinalGetters;
    }

    @Override
    public void setFauxFileSystem(FauxFileSystem fauxFileSystem) {
        this.fauxFileSystem = fauxFileSystem;
    }

    @Override
    public Map<String, MithraObjectTypeWrapper> getMithraObjects() {
        return this.mithraObjects;
    }

    @Override
    public Map<String, MithraEmbeddedValueObjectTypeWrapper> getMithraEmbeddedValueObjects() {
        return this.mithraEmbeddedValueObjects;
    }

    @Override
    public String getChecksum() {
        String result = Long.toHexString(this.crc32.getValue());
        while (result.length() < 8) {
            result = "0" + result;
        }
        return result;
    }

    @Override
    public Map<String, MithraInterfaceType> getMithraInterfaces() {
        return this.mithraInterfaces;
    }

    @Override
    public String parse() throws MithraGeneratorException {
        try {
            FauxFile file = this.fauxFileSystem.newFile(this.mithraClassListXml);
            this.parseMithraXml(file.getName(), null, new DirectoryFileProvider(this.fauxFileSystem, file.getParent()));
            return file.getPath();
        }
        catch (Throwable e) {
            throw new MithraGeneratorException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseMithraXml(String fileName, String importSource, FileProvider fileProvider) throws FileNotFoundException {
        InputStream mithraFileIs = null;
        try {
            FileInputStreamWithSize streamWithSize = fileProvider.getFileInputStream(fileName);
            FullFileBuffer ffb = new FullFileBuffer();
            ffb.bufferFile(streamWithSize.getInputStream(), (int)streamWithSize.getSize());
            ffb.updateCrc(this.crc32);
            mithraFileIs = ffb.getBufferedInputStream();
            Object obj = new MithraGeneratorUnmarshaller().parse(mithraFileIs, fileName);
            this.logger.debug(obj.getClass().getName() + ": " + MithraType.class.getName());
            MithraType result = (MithraType)obj;
            long start = System.currentTimeMillis();
            int normalObjects = this.parseMithraObjects(result, importSource, fileProvider);
            int pureObjects = this.parseMithraPureObjects(result, importSource, fileProvider);
            int tempObjects = this.parseMithraTempObjects(result, importSource, fileProvider);
            int embeddedObjects = this.parseMithraEmbeddedValueObjects(result, importSource, fileProvider);
            int mithraInterfaceObjects = this.parseMithraInterfaceObjects(result, importSource, fileProvider);
            String msg = fileName + ": parsed ";
            msg = this.concatParsed(msg, normalObjects, "normal");
            msg = this.concatParsed(msg, pureObjects, "pure");
            msg = this.concatParsed(msg, tempObjects, "temp");
            msg = this.concatParsed(msg, embeddedObjects, "embedded");
            msg = this.concatParsed(msg, mithraInterfaceObjects, "mithraInterface");
            msg = msg + " Mithra objects in " + (System.currentTimeMillis() - start) + " ms.";
            this.logger.info(msg);
        }
        catch (MithraGeneratorParserException e) {
            try {
                throw new MithraGeneratorException("Unable to parse " + fileName, e);
                catch (IOException e2) {
                    throw new MithraGeneratorException("Unable to read file " + fileName, e2);
                }
            }
            catch (Throwable throwable) {
                this.closeIs(mithraFileIs);
                fileProvider.close();
                throw throwable;
            }
        }
        this.closeIs(mithraFileIs);
        fileProvider.close();
    }

    private int parseMithraObjects(final MithraType mithraType, final String importSource, final FileProvider fileProvider) throws FileNotFoundException {
        List<MithraObjectResourceType> mithraObjectList = mithraType.getMithraObjectResources();
        this.chopAndStickResource.resetSerialResource();
        for (int i = 0; i < mithraObjectList.size(); ++i) {
            final MithraObjectResourceType mithraObjectResourceType = mithraObjectList.get(i);
            final String objectName = mithraObjectResourceType.getName();
            this.getExecutor().submit(new GeneratorTask(i){

                @Override
                public void run() {
                    MithraBaseObjectType mithraObject = MithraXMLObjectTypeParser.this.parseMithraObject(objectName, MithraXMLObjectTypeParser.this.mithraObjects, fileProvider, this, "normal");
                    if (mithraObject != null) {
                        boolean isGenerateInterfaces;
                        String objectFileName = objectName + ".xml";
                        boolean bl = isGenerateInterfaces = !mithraObjectResourceType.isGenerateInterfacesSet() ? mithraType.isGenerateInterfaces() : mithraObjectResourceType.isGenerateInterfaces();
                        boolean enableOffHeap = !mithraObjectResourceType.isEnableOffHeapSet() ? mithraType.isEnableOffHeap() || MithraXMLObjectTypeParser.this.forceOffHeap : mithraObjectResourceType.isEnableOffHeap();
                        MithraObjectTypeWrapper wrapper = new MithraObjectTypeWrapper(mithraObject, objectFileName, importSource, isGenerateInterfaces, MithraXMLObjectTypeParser.this.ignorePackageNamingConvention, MithraXMLObjectTypeParser.this.logger);
                        wrapper.setGenerateFileHeaders(MithraXMLObjectTypeParser.this.generateFileHeaders);
                        wrapper.setReplicated(mithraObjectResourceType.isReplicated());
                        wrapper.setIgnoreNonGeneratedAbstractClasses(MithraXMLObjectTypeParser.this.ignoreNonGeneratedAbstractClasses);
                        wrapper.setIgnoreTransactionalMethods(MithraXMLObjectTypeParser.this.ignoreTransactionalMethods);
                        wrapper.setReadOnlyInterfaces(mithraObjectResourceType.isReadOnlyInterfacesSet() ? mithraObjectResourceType.isReadOnlyInterfaces() : mithraType.isReadOnlyInterfaces());
                        wrapper.setDefaultFinalGetters(MithraXMLObjectTypeParser.this.defaultFinalGetters);
                        wrapper.setEnableOffHeap(enableOffHeap);
                        MithraXMLObjectTypeParser.this.mithraObjects.put(mithraObjectResourceType.getName(), wrapper);
                    }
                }
            });
        }
        this.waitForExecutorWithCheck();
        return mithraObjectList.size();
    }

    private int parseMithraPureObjects(final MithraType mithraType, final String importSource, final FileProvider fileProvider) throws FileNotFoundException {
        List<MithraPureObjectResourceType> mithraPureObjectList = mithraType.getMithraPureObjectResources();
        if (!mithraPureObjectList.isEmpty()) {
            this.chopAndStickResource.resetSerialResource();
            for (int i = 0; i < mithraPureObjectList.size(); ++i) {
                final MithraPureObjectResourceType mithraPureObjectResourceType = mithraPureObjectList.get(i);
                this.getExecutor().submit(new GeneratorTask(i){

                    @Override
                    public void run() {
                        String objectName = mithraPureObjectResourceType.getName();
                        MithraBaseObjectType mithraObject = MithraXMLObjectTypeParser.this.parseMithraObject(objectName, MithraXMLObjectTypeParser.this.mithraObjects, fileProvider, this, "pure");
                        if (mithraObject != null) {
                            String objectFileName = objectName + ".xml";
                            boolean enableOffHeap = !mithraPureObjectResourceType.isEnableOffHeapSet() ? mithraType.isEnableOffHeap() || MithraXMLObjectTypeParser.this.forceOffHeap : mithraPureObjectResourceType.isEnableOffHeap();
                            MithraObjectTypeWrapper wrapper = new MithraObjectTypeWrapper(mithraObject, objectFileName, importSource, false, MithraXMLObjectTypeParser.this.ignorePackageNamingConvention, MithraXMLObjectTypeParser.this.logger);
                            wrapper.setGenerateFileHeaders(MithraXMLObjectTypeParser.this.generateFileHeaders);
                            wrapper.setIgnoreNonGeneratedAbstractClasses(MithraXMLObjectTypeParser.this.ignoreNonGeneratedAbstractClasses);
                            wrapper.setIgnoreTransactionalMethods(MithraXMLObjectTypeParser.this.ignoreTransactionalMethods);
                            wrapper.setPure(true);
                            wrapper.setEnableOffHeap(enableOffHeap);
                            MithraXMLObjectTypeParser.this.mithraObjects.put(mithraPureObjectResourceType.getName(), wrapper);
                        }
                    }
                });
            }
            this.waitForExecutorWithCheck();
        }
        return mithraPureObjectList.size();
    }

    private int parseMithraTempObjects(MithraType mithraType, final String importSource, final FileProvider fileProvider) throws FileNotFoundException {
        List<MithraTempObjectResourceType> mithraTempObjectList = mithraType.getMithraTempObjectResources();
        if (mithraTempObjectList.size() > 0) {
            this.chopAndStickResource.resetSerialResource();
            for (int i = 0; i < mithraTempObjectList.size(); ++i) {
                final MithraTempObjectResourceType mithraTempObjectResourceType = mithraTempObjectList.get(i);
                this.getExecutor().submit(new GeneratorTask(i){

                    @Override
                    public void run() {
                        String objectName = mithraTempObjectResourceType.getName();
                        MithraBaseObjectType mithraObject = MithraXMLObjectTypeParser.this.parseMithraObject(objectName, MithraXMLObjectTypeParser.this.mithraObjects, fileProvider, this, "temp");
                        if (mithraObject != null) {
                            String objectFileName = objectName + ".xml";
                            MithraObjectTypeWrapper wrapper = new MithraObjectTypeWrapper(mithraObject, objectFileName, importSource, false, MithraXMLObjectTypeParser.this.ignorePackageNamingConvention, MithraXMLObjectTypeParser.this.logger);
                            wrapper.setGenerateFileHeaders(MithraXMLObjectTypeParser.this.generateFileHeaders);
                            wrapper.setIgnoreNonGeneratedAbstractClasses(MithraXMLObjectTypeParser.this.ignoreNonGeneratedAbstractClasses);
                            wrapper.setIgnoreTransactionalMethods(MithraXMLObjectTypeParser.this.ignoreTransactionalMethods);
                            wrapper.setTemporary(true);
                            MithraXMLObjectTypeParser.this.mithraObjects.put(mithraTempObjectResourceType.getName(), wrapper);
                        }
                    }
                });
            }
            this.waitForExecutorWithCheck();
        }
        return mithraTempObjectList.size();
    }

    private int parseMithraEmbeddedValueObjects(MithraType mithraType, final String importSource, final FileProvider fileProvider) throws FileNotFoundException {
        List<MithraEmbeddedValueObjectResourceType> mithraEmbeddedValueObjectList = mithraType.getMithraEmbeddedValueObjectResources();
        if (!mithraEmbeddedValueObjectList.isEmpty()) {
            this.chopAndStickResource.resetSerialResource();
            for (int i = 0; i < mithraEmbeddedValueObjectList.size(); ++i) {
                final MithraEmbeddedValueObjectResourceType mithraEmbeddedValueObjectResourceType = mithraEmbeddedValueObjectList.get(i);
                this.getExecutor().submit(new GeneratorTask(i){

                    @Override
                    public void run() {
                        String objectName = mithraEmbeddedValueObjectResourceType.getName();
                        MithraEmbeddedValueObjectType evo = (MithraEmbeddedValueObjectType)MithraXMLObjectTypeParser.this.parseMithraBaseObject(objectName, MithraXMLObjectTypeParser.this.mithraEmbeddedValueObjects, fileProvider, this);
                        if (evo != null) {
                            String objectFileName = objectName + ".xml";
                            MithraEmbeddedValueObjectTypeWrapper wrapper = new MithraEmbeddedValueObjectTypeWrapper(evo, objectFileName, importSource);
                            wrapper.setIgnoreNonGeneratedAbstractClasses(MithraXMLObjectTypeParser.this.ignoreNonGeneratedAbstractClasses);
                            MithraXMLObjectTypeParser.this.mithraEmbeddedValueObjects.put(mithraEmbeddedValueObjectResourceType.getName(), wrapper);
                        }
                    }
                });
            }
            this.waitForExecutorWithCheck();
        }
        return mithraEmbeddedValueObjectList.size();
    }

    private MithraInterfaceType parseMithraInterfaceType(String objectName, Map objectMap, FileProvider fileProvider, GeneratorTask task, boolean isReadOnlyInterfaces, String importedSource) {
        MithraInterfaceType mithraObject = (MithraInterfaceType)this.parseMithraType(objectName, objectMap, fileProvider, task);
        mithraObject.setReadOnlyInterfaces(isReadOnlyInterfaces);
        mithraObject.setImportedSource(importedSource);
        this.checkClassName(objectName, mithraObject.getClassName());
        mithraObject.postInitialize(objectName);
        return mithraObject;
    }

    private MithraBaseObjectType parseMithraObject(String objectName, Map objectMap, FileProvider fileProvider, GeneratorTask task, String errorType) {
        return this.parseMithraBaseObject(objectName, objectMap, fileProvider, task);
    }

    private void checkClassName(String objectName, String className) {
        if (objectName.contains("/")) {
            objectName = objectName.substring(objectName.lastIndexOf(47) + 1);
        }
        if (!objectName.equals(className)) {
            throw new MithraGeneratorException("XML filename: '" + objectName + "' must match class name specified: '" + className + "'");
        }
    }

    private int parseMithraInterfaceObjects(MithraType mithraType, final String importSource, final FileProvider fileProvider) throws FileNotFoundException {
        List<MithraInterfaceResourceType> mithraObjectList = mithraType.getMithraInterfaceResources();
        this.chopAndStickResource.resetSerialResource();
        for (int i = 0; i < mithraObjectList.size(); ++i) {
            final MithraInterfaceResourceType mithraObjectResourceType = mithraObjectList.get(i);
            final String objectName = mithraObjectResourceType.getName();
            this.getExecutor().submit(new GeneratorTask(i){

                @Override
                public void run() {
                    MithraInterfaceType mithraObject = MithraXMLObjectTypeParser.this.parseMithraInterfaceType(objectName, MithraXMLObjectTypeParser.this.mithraInterfaces, fileProvider, this, mithraObjectResourceType.isReadOnlyInterfaces(), importSource);
                    if (mithraObject != null) {
                        MithraXMLObjectTypeParser.this.mithraInterfaces.put(mithraObjectResourceType.getName(), mithraObject);
                    }
                }
            });
        }
        this.waitForExecutorWithCheck();
        return mithraObjectList.size();
    }

    private MithraBaseObjectType parseMithraBaseObject(String objectName, Map objectMap, FileProvider fileProvider, GeneratorTask task) {
        MithraBaseObjectType mithraObject = (MithraBaseObjectType)this.parseMithraType(objectName, objectMap, fileProvider, task);
        this.checkClassName(objectName, mithraObject.getClassName());
        return mithraObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object parseMithraType(String objectName, Map objectMap, FileProvider fileProvider, GeneratorTask task) {
        InputStream objectFileIs;
        Object mithraObject;
        block21: {
            mithraObject = null;
            this.logger.info("Reading " + objectName);
            if (fileProvider.excludeObject(objectName)) {
                this.logger.info("Skipping " + objectName + ", excluded");
                return mithraObject;
            }
            if (objectMap.containsKey(objectName)) {
                throw new MithraGeneratorException("Attempted to add object " + objectName + " twice");
            }
            String objectFileName = objectName + ".xml";
            objectFileIs = null;
            boolean serialAquired = false;
            try {
                FileInputStreamWithSize streamWithSize = fileProvider.getFileInputStream(objectFileName);
                FullFileBuffer ffb = this.getFullFileBuffer();
                this.chopAndStickResource.acquireIoResource();
                try {
                    ffb.bufferFile(streamWithSize.getInputStream(), (int)streamWithSize.getSize());
                }
                finally {
                    this.chopAndStickResource.releaseIoResource();
                }
                task.acquireSerialResource();
                serialAquired = true;
                try {
                    ffb.updateCrc(this.crc32);
                }
                finally {
                    task.releaseSerialResource();
                }
                this.chopAndStickResource.acquireCpuResource();
                try {
                    objectFileIs = streamWithSize.getInputStream();
                    mithraObject = new MithraGeneratorUnmarshaller().parse(ffb.getBufferedInputStream(), objectFileName);
                }
                finally {
                    this.chopAndStickResource.releaseCpuResource();
                }
                if (serialAquired) break block21;
            }
            catch (FileNotFoundException e) {
                try {
                    throw new MithraGeneratorException("Unable to find " + objectFileName, e);
                    catch (MithraGeneratorParserException e2) {
                        throw new MithraGeneratorException("Unable to parse " + objectFileName + " " + e2.getMessage(), e2);
                    }
                    catch (IOException e3) {
                        throw new MithraGeneratorException("Unable to read x" + objectFileName, e3);
                    }
                }
                catch (Throwable throwable) {
                    if (!serialAquired) {
                        task.acquireSerialResource();
                        task.releaseSerialResource();
                    }
                    this.closeIs(objectFileIs);
                    throw throwable;
                }
            }
            task.acquireSerialResource();
            task.releaseSerialResource();
        }
        this.closeIs(objectFileIs);
        return mithraObject;
    }

    private String concatParsed(String msg, int count, String type) {
        if (count > 0) {
            msg = msg + count + " " + type + ", ";
        }
        return msg;
    }

    private void waitForExecutorWithCheck() {
        this.getExecutor().waitUntilDone();
        if (this.executorError != null) {
            throw new MithraGeneratorException("exception while generating", this.executorError);
        }
    }

    private void closeIs(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new MithraGeneratorException("Exception closing InputStream", e);
            }
        }
    }

    public ChopAndStickResource getChopAndStickResource() {
        return this.chopAndStickResource;
    }

    public AwaitingThreadExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = new AwaitingThreadExecutor(Runtime.getRuntime().availableProcessors() + 1, "Mithra Generator");
            this.executor.setExceptionHandler(new AutoShutdownThreadExecutor.ExceptionHandler(){

                @Override
                public void handleException(AutoShutdownThreadExecutor executor, Runnable target, Throwable exception) {
                    executor.shutdownNow();
                    MithraXMLObjectTypeParser.this.logger.error("Error in runnable target. Shutting down queue " + exception.getClass().getName() + " :" + exception.getMessage());
                    MithraXMLObjectTypeParser.this.executorError = exception;
                }
            });
        }
        return this.executor;
    }

    private void createSortedList() {
        this.sortedMithraObjects = new ArrayList<MithraObjectTypeWrapper>(this.mithraObjects.values());
        Collections.sort(this.sortedMithraObjects, new ParentClassComparator());
    }

    private void createSortedEmbeddedValueObjectList() {
        this.sortedMithraEmbeddedValueObjects = new ArrayList<MithraEmbeddedValueObjectTypeWrapper>(this.mithraEmbeddedValueObjects.values());
    }

    public List<MithraEmbeddedValueObjectTypeWrapper> getSortedMithraEmbeddedValueObjects() {
        return this.sortedMithraEmbeddedValueObjects;
    }

    private FullFileBuffer getFullFileBuffer() {
        FullFileBuffer result = this.fullFileBufferThreadLocal.get();
        if (result == null) {
            result = new FullFileBuffer();
            this.fullFileBufferThreadLocal.set(result);
        }
        return result;
    }

    public abstract class GeneratorTask
    implements Runnable {
        private int resourceNumber;

        public GeneratorTask(int resourceNumber) {
            this.resourceNumber = resourceNumber;
        }

        public void acquireSerialResource() {
            MithraXMLObjectTypeParser.this.getChopAndStickResource().acquireSerialResource(this.resourceNumber);
        }

        public void releaseSerialResource() {
            MithraXMLObjectTypeParser.this.getChopAndStickResource().releaseSerialResource();
        }
    }

    private class ParentClassComparator
    implements Comparator {
        private ParentClassComparator() {
        }

        public int compare(Object o1, Object o2) {
            MithraObjectTypeWrapper left = (MithraObjectTypeWrapper)o1;
            MithraObjectTypeWrapper right = (MithraObjectTypeWrapper)o2;
            Map<String, MithraObjectTypeWrapper> mithraObjects = MithraXMLObjectTypeParser.this.getMithraObjects();
            int result = left.getHierarchyDepth(mithraObjects) - right.getHierarchyDepth(mithraObjects);
            if (result == 0) {
                result = left.getClassName().compareTo(right.getClassName());
            }
            return result;
        }
    }
}

