/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class TemplateFromJavaTask
extends Task {
    private String input;
    private String startDelimeter = "//beginTemplate";
    private String endDelimeter = "//endTemplate";
    private String output;

    public void setOutput(String output) {
        this.output = output;
    }

    public void setEndDelimeter(String endDelimeter) {
        this.endDelimeter = endDelimeter;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setStartDelimeter(String startDelimeter) {
        this.startDelimeter = startDelimeter;
    }

    public void execute() throws BuildException {
        File inputFile = new File(this.input);
        if (!inputFile.exists()) {
            throw new BuildException("the input " + this.input + " does not exist");
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream((int)inputFile.length());
        LineNumberReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(inputFile));
            String line = reader.readLine();
            File out = null;
            boolean writing = false;
            while (line != null) {
                if (writing) {
                    if (line.startsWith(this.endDelimeter)) {
                        writing = false;
                        outStream.close();
                    } else {
                        outStream.write(line.getBytes());
                        outStream.write(10);
                    }
                } else if (line.startsWith(this.startDelimeter)) {
                    String templateSection = line.substring(this.startDelimeter.length() + 1).trim();
                    writing = true;
                    out = new File(this.output + "." + templateSection);
                }
                line = reader.readLine();
            }
            outStream.close();
            this.copyIfChanged(outStream.toByteArray(), out);
            outStream = null;
        }
        catch (IOException e) {
            throw new BuildException("could not write template", (Throwable)e);
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void copyIfChanged(byte[] src, File outFile) throws IOException {
        boolean copyFile = false;
        if (!outFile.exists() || outFile.length() != (long)src.length) {
            copyFile = true;
        } else {
            byte[] outContent = this.readFile(outFile);
            for (int i = 0; i < src.length; ++i) {
                if (src[i] == outContent[i]) continue;
                copyFile = true;
                break;
            }
        }
        if (copyFile && outFile.exists() && !outFile.canWrite()) {
            throw new IOException(outFile + " must be updated, but it is readonly.");
        }
        if (copyFile) {
            FileOutputStream fout = new FileOutputStream(outFile);
            fout.write(src);
            fout.close();
        }
    }

    private byte[] readFile(File file) throws IOException {
        int length = (int)file.length();
        FileInputStream fis = new FileInputStream(file);
        byte[] result = new byte[length];
        for (int pos = 0; pos < length; pos += fis.read(result, pos, length - pos)) {
        }
        fis.close();
        return result;
    }
}

