/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.computedattribute;

import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.computedattribute.Expression;
import com.gs.fw.common.mithra.generator.computedattribute.functiongen.FunctionGenerator;
import com.gs.fw.common.mithra.generator.computedattribute.type.Type;
import com.gs.fw.common.mithra.generator.util.StringUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FunctionExpression
extends Expression {
    private String functionName;
    private Expression sourceExpression;
    private List<Expression> parameters = new ArrayList<Expression>();
    private boolean finished;
    private FunctionGenerator functionGenerator;

    public FunctionExpression(Expression expression) {
        this.sourceExpression = expression;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    @Override
    public Type getType() {
        return this.functionGenerator.getReturnType();
    }

    private FunctionGenerator createFunctionGenerator(List<String> errors) {
        try {
            String className = "com.gs.fw.common.mithra.generator.functiongen" + this.sourceExpression.getType().toString() + StringUtility.firstLetterToUpper(this.functionName) + "FuncGen";
            return (FunctionGenerator)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            errors.add("Could not find function with name " + this.functionName + "for type " + this.sourceExpression.getType());
            return null;
        }
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Expression> parameters) {
        this.parameters = parameters;
    }

    public Expression getSourceExpression() {
        return this.sourceExpression;
    }

    public void addParameter(Expression parameter) {
        this.parameters.add(parameter);
    }

    public void markFinished() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void addAttributeList(Set<String> result) {
        this.sourceExpression.addAttributeList(result);
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.parameters.get(i).addAttributeList(result);
        }
    }

    @Override
    public void resolveAttributes(MithraObjectTypeWrapper wrapper, List<String> errors) {
        this.sourceExpression.resolveAttributes(wrapper, errors);
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.parameters.get(i).resolveAttributes(wrapper, errors);
        }
        this.functionGenerator = this.createFunctionGenerator(errors);
    }
}

