/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.databasetype;

import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import java.util.HashMap;
import java.util.Map;

public class Udb82DatabaseType
implements CommonDatabaseType {
    private static final Udb82DatabaseType instance = new Udb82DatabaseType();
    private static final Map<String, String> sqlToJavaTypes = new HashMap<String, String>();

    protected Udb82DatabaseType() {
    }

    public static Udb82DatabaseType getInstance() {
        return instance;
    }

    @Override
    public String getSqlDataTypeForNullableBoolean() {
        return "smallint";
    }

    @Override
    public String getSqlDataTypeForBoolean() {
        return "smallint";
    }

    @Override
    public String getSqlDataTypeForTimestamp() {
        return "timestamp";
    }

    @Override
    public String getSqlDataTypeForTime() {
        return "time";
    }

    @Override
    public String getSqlDataTypeForTinyInt() {
        return "smallint";
    }

    @Override
    public String getSqlDataTypeForVarBinary() {
        return "blob";
    }

    @Override
    public String getSqlDataTypeForByte() {
        return "smallint";
    }

    @Override
    public String getSqlDataTypeForChar() {
        return "character";
    }

    @Override
    public String getSqlDataTypeForDateTime() {
        return "date";
    }

    @Override
    public String getSqlDataTypeForDouble() {
        return "double";
    }

    @Override
    public String getSqlDataTypeForFloat() {
        return "real";
    }

    @Override
    public String getSqlDataTypeForInt() {
        return "integer";
    }

    @Override
    public String getSqlDataTypeForLong() {
        return "bigint";
    }

    @Override
    public String getSqlDataTypeForShortJava() {
        return "smallint";
    }

    @Override
    public String getSqlDataTypeForString() {
        return "varchar";
    }

    @Override
    public String getSqlDataTypeForBigDecimal() {
        return "decimal";
    }

    @Override
    public String getJavaTypeFromSql(String sql, Integer precision, Integer decimal) {
        return sqlToJavaTypes.get(sql);
    }

    static {
        sqlToJavaTypes.put("blob", "not implemented");
        sqlToJavaTypes.put("bigint", "long");
        sqlToJavaTypes.put("integer", "int");
        sqlToJavaTypes.put("smallint", "short");
        sqlToJavaTypes.put("tinyint", "short");
        sqlToJavaTypes.put("double", "double");
        sqlToJavaTypes.put("character", "String");
        sqlToJavaTypes.put("char", "String");
        sqlToJavaTypes.put("varchar", "String");
        sqlToJavaTypes.put("blob", "String");
        sqlToJavaTypes.put("clob", "String");
        sqlToJavaTypes.put("date", "Timestamp");
        sqlToJavaTypes.put("time", "Time");
        sqlToJavaTypes.put("timestamp", "Timestamp");
        sqlToJavaTypes.put("bit", "byte");
        sqlToJavaTypes.put("decimal", "BigDecimal");
        sqlToJavaTypes.put("real", "float");
    }
}

