/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.mapper;

import com.gs.fw.common.mithra.generator.AbstractAttribute;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.RelationshipAttribute;
import com.gs.fw.common.mithra.generator.mapper.JoinNode;
import com.gs.fw.common.mithra.generator.queryparser.ASTAttributeName;
import com.gs.fw.common.mithra.generator.queryparser.ASTRelationalExpression;
import com.gs.fw.common.mithra.generator.queryparser.MithraQLVisitorAdapter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;

public class JoinOrderQueryConversionVisitor
extends MithraQLVisitorAdapter {
    private RelationshipAttribute relationshipAttribute;
    private HashSet joins = new HashSet();

    public JoinOrderQueryConversionVisitor(RelationshipAttribute relationshipAttribute) {
        this.relationshipAttribute = relationshipAttribute;
        this.relationshipAttribute.getParsedQuery().childrenPolymorphicAccept(this, null);
    }

    public JoinNode getJoinTree() {
        JoinNode root = null;
        HashSet<String> alreadyProcessed = new HashSet<String>();
        Stack<JoinNode> toFollow = new Stack<JoinNode>();
        root = this.createFirstJoinNode(root, alreadyProcessed, toFollow);
        while (!toFollow.isEmpty() && !this.joins.isEmpty()) {
            JoinNode currentRoot = toFollow.pop();
            Iterator it = this.joins.iterator();
            while (it.hasNext()) {
                Join join = (Join)it.next();
                if (!join.hasObject(currentRoot.getLeft())) continue;
                it.remove();
                join.alignToLeft(currentRoot.getLeft());
                if (alreadyProcessed.contains(join.getRight().getClassName())) {
                    throw new RuntimeException("Triangluar relationship not supported, in relationship " + this.relationshipAttribute.getName() + " in object " + this.relationshipAttribute.getFromObject().getClassName() + " joining " + join.getLeft().getClassName() + " and " + join.getRight().getClassName());
                }
                toFollow.push(currentRoot.addRight(join.getRight(), this.relationshipAttribute));
                alreadyProcessed.add(join.getRight().getClassName());
            }
        }
        root.reorder(this.relationshipAttribute.getRelatedObject());
        return root;
    }

    private JoinNode createFirstJoinNode(JoinNode root, HashSet<String> alreadyProcessed, Stack<JoinNode> toFollow) {
        Iterator it = this.joins.iterator();
        while (it.hasNext()) {
            Join join = (Join)it.next();
            if (!join.isJoinedToThis) continue;
            it.remove();
            join.alignToLeft(this.relationshipAttribute.getFromObject());
            if (root == null) {
                root = new JoinNode(this.relationshipAttribute.getFromObject(), true);
            }
            toFollow.push(root.addRight(join.getRight(), this.relationshipAttribute));
            alreadyProcessed.add(join.getRight().getClassName());
        }
        return root;
    }

    private void addJoin(ASTRelationalExpression node) {
        AbstractAttribute leftAttribute = node.getLeft().getAttribute();
        AbstractAttribute rightAttribute = ((ASTAttributeName)node.getRight()).getAttribute();
        Join join = new Join(leftAttribute.getOwner(), rightAttribute.getOwner(), node.involvesThis());
        this.joins.add(join);
    }

    @Override
    public Object visit(ASTRelationalExpression node, Object data) {
        if (node.isJoin()) {
            this.addJoin(node);
        }
        return null;
    }

    private static class Join {
        private MithraObjectTypeWrapper left;
        private MithraObjectTypeWrapper right;
        private boolean isJoinedToThis;

        public Join(MithraObjectTypeWrapper left, MithraObjectTypeWrapper right, boolean joinedToThis) {
            this.left = left;
            this.right = right;
            this.isJoinedToThis = joinedToThis;
        }

        public boolean equals(Object obj) {
            Join other = (Join)obj;
            return other.isJoinedToThis == this.isJoinedToThis && (other.left.getClassName().equals(this.left.getClassName()) && other.right.getClassName().equals(this.right.getClassName()) || other.right.getClassName().equals(this.left.getClassName()) && other.left.getClassName().equals(this.right.getClassName()));
        }

        public int hashCode() {
            return this.left.getClassName().hashCode() ^ this.right.getClassName().hashCode();
        }

        public void alignToLeft(MithraObjectTypeWrapper fromObject) {
            if (!this.left.getClassName().equals(fromObject.getClassName())) {
                MithraObjectTypeWrapper tmp = this.left;
                this.left = this.right;
                this.right = tmp;
            }
        }

        public boolean hasObject(MithraObjectTypeWrapper lastRight) {
            return this.left.getClassName().equals(lastRight.getClassName()) || this.right.getClassName().equals(lastRight.getClassName());
        }

        public MithraObjectTypeWrapper getLeft() {
            return this.left;
        }

        public MithraObjectTypeWrapper getRight() {
            return this.right;
        }
    }
}

