/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.metamodel;

import com.gs.fw.common.mithra.generator.Attribute;
import com.gs.fw.common.mithra.generator.metamodel.AttributeInterfaceTypeAbstract;
import com.gs.fw.common.mithra.generator.type.JavaType;
import com.gs.fw.common.mithra.generator.util.StringUtility;
import java.util.List;

public class AttributeInterfaceType
extends AttributeInterfaceTypeAbstract {
    private JavaType getType() {
        return JavaType.create(this.getJavaType());
    }

    public String getTypeAsString() {
        return this.getType().getJavaTypeString();
    }

    public String getTypeAsStringPrimary() {
        return this.getType().getJavaTypeStringPrimary();
    }

    public String getAttributeClassName() {
        return this.getTypeAsStringPrimary() + "Attribute";
    }

    public String getGetter() {
        return this.getType().getGetterPrefix() + StringUtility.firstLetterToUpper(this.getName());
    }

    public String getSetter() {
        return "set" + StringUtility.firstLetterToUpper(this.getName());
    }

    public boolean isCompatibleWithSuperAttribute(AttributeInterfaceType attributeInterfaceType, List<String> errorMessages) {
        if (!this.isCompatible(attributeInterfaceType.getTypeAsString())) {
            errorMessages.add("Inconsistent Attribute Type.  " + this.getName() + " has a type " + this.getTypeAsString() + " which is not consistent with its SuperInterface Type : " + attributeInterfaceType.getTypeAsString());
            return false;
        }
        return true;
    }

    public boolean validAttribute(Attribute localAttribute, String className, String mithraInterfaceName, List<String> errors) {
        if (!this.isCompatible(localAttribute.getTypeAsString())) {
            errors.add("Object " + className + " is defined to implement the MithraInterface " + mithraInterfaceName + " but the attribute - " + this.getName() + " has either not been defined or has a incorrect type. ");
            return false;
        }
        return true;
    }

    private boolean isCompatible(String attributeTypeAsString) {
        return this.getTypeAsString().equals(attributeTypeAsString);
    }
}

