/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.metamodel;

import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorMarshaller;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorUnmarshaller;
import com.gs.fw.common.mithra.generator.metamodel.SuperClassAttributeType;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class MithraBaseObjectTypeAbstract
implements Serializable {
    private boolean initializePrimitivesToNull = false;
    private boolean _isInitializePrimitivesToNullSet;
    private static Map<String, Integer> elementNameStates = new HashMap<String, Integer>();
    private String packageName;
    private String className;
    private SuperClassAttributeType superClass;
    private List<String> imports = MithraGeneratorUnmarshaller.emptyList();
    private String updateListener;
    private Object _parent;

    public Object parent() {
        return this._parent;
    }

    public void _setParent(Object parent) {
        this._parent = parent;
    }

    public void parse(MithraGeneratorUnmarshaller unmarshaller, String typeName) throws XMLStreamException {
        this.parseAttributes(unmarshaller);
        this.parseElements(unmarshaller, typeName);
    }

    protected void initListElements(MithraGeneratorUnmarshaller unmarshaller) {
        this.imports = unmarshaller.newList();
    }

    protected void parseElements(MithraGeneratorUnmarshaller unmarshaller, String typeName) throws XMLStreamException {
        this.initListElements(unmarshaller);
        int eventType = unmarshaller.getNextStartOrEnd();
        if (!unmarshaller.isAtEnd(eventType, typeName)) {
            XMLStreamReader xmlStreamReader = unmarshaller.getXmlStreamReader();
            int currentElementState = Integer.MAX_VALUE;
            int state = 0;
            while (eventType == 1) {
                String elementName = xmlStreamReader.getLocalName();
                currentElementState = this.getState(elementName);
                if (state <= currentElementState) {
                    if (state < 0) {
                        unmarshaller.throwException("unexpected element in MithraBaseObjectType: " + elementName);
                    }
                } else {
                    unmarshaller.throwException("element out of order " + elementName + " in type MithraBaseObjectType");
                }
                this.parseElement(unmarshaller, state, elementName);
                state = currentElementState;
                eventType = unmarshaller.getNextStartOrEnd();
            }
            if (state < 2) {
                unmarshaller.throwException("expecting at least one element of type ClassName in MithraBaseObjectType");
            }
            unmarshaller.expectEnd(eventType, typeName);
            this.checkListMinOccurs(unmarshaller);
        }
    }

    protected void checkListMinOccurs(MithraGeneratorUnmarshaller unmarshaller) {
    }

    protected int getState(String elementName) throws XMLStreamException {
        Integer state = elementNameStates.get(elementName);
        if (state != null) {
            return state;
        }
        return -1;
    }

    protected void parseElement(MithraGeneratorUnmarshaller unmarshaller, int state, String elementName) throws XMLStreamException {
        if (elementName.equals("PackageName")) {
            if (!this.isPackageNameSet()) {
                this.setPackageName(unmarshaller.parseTokenString("PackageName"));
            } else {
                unmarshaller.throwException("too many occurrences of element PackageName in type MithraBaseObjectType. Max occurrences is 1");
            }
        }
        if (elementName.equals("ClassName")) {
            if (!this.isClassNameSet()) {
                this.setClassName(unmarshaller.parseTokenString("ClassName"));
            } else {
                unmarshaller.throwException("too many occurrences of element ClassName in type MithraBaseObjectType. Max occurrences is 1");
            }
        }
        if (elementName.equals("SuperClass")) {
            if (!this.isSuperClassSet()) {
                SuperClassAttributeType _superClass = new SuperClassAttributeType();
                _superClass.parse(unmarshaller, "SuperClass");
                _superClass._setParent(this);
                this.setSuperClass(_superClass);
            } else {
                unmarshaller.throwException("too many occurrences of element SuperClass in type MithraBaseObjectType. Max occurrences is 1");
            }
        }
        if (elementName.equals("Import")) {
            this.getImports().add(unmarshaller.parseTokenString("Import"));
        }
        if (elementName.equals("UpdateListener")) {
            if (!this.isUpdateListenerSet()) {
                this.setUpdateListener(unmarshaller.parseTokenString("UpdateListener"));
            } else {
                unmarshaller.throwException("too many occurrences of element UpdateListener in type MithraBaseObjectType. Max occurrences is 1");
            }
        }
    }

    protected void parseAttributes(MithraGeneratorUnmarshaller unmarshaller) throws XMLStreamException {
        XMLStreamReader xmlStreamReader = unmarshaller.getXmlStreamReader();
        int attributes = xmlStreamReader.getAttributeCount();
        for (int i = 0; i < attributes; ++i) {
            String attributeValue;
            String attributeName = xmlStreamReader.getAttributeName(i).getLocalPart();
            if (this.parseAttribute(unmarshaller, attributeName, attributeValue = xmlStreamReader.getAttributeValue(i))) continue;
            unmarshaller.unknownAttribute(attributeName, attributeValue);
        }
    }

    protected boolean parseAttribute(MithraGeneratorUnmarshaller unmarshaller, String attributeName, String attributeValue) throws XMLStreamException {
        if (attributeName.equals("initializePrimitivesToNull")) {
            this.setInitializePrimitivesToNull(unmarshaller.parseBoolean("initializePrimitivesToNull", attributeValue));
            return true;
        }
        return false;
    }

    public boolean isInitializePrimitivesToNull() {
        return this.initializePrimitivesToNull;
    }

    public void setInitializePrimitivesToNull(boolean initializePrimitivesToNull) {
        this.initializePrimitivesToNull = initializePrimitivesToNull;
        this._isInitializePrimitivesToNullSet = true;
    }

    public boolean isInitializePrimitivesToNullSet() {
        return this._isInitializePrimitivesToNullSet;
    }

    public void unsetInitializePrimitivesToNull() {
        this._isInitializePrimitivesToNullSet = false;
        this.initializePrimitivesToNull = false;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public boolean isPackageNameSet() {
        return this.packageName != null;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isClassNameSet() {
        return this.className != null;
    }

    public SuperClassAttributeType getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(SuperClassAttributeType superClass) {
        this.superClass = superClass;
    }

    public boolean isSuperClassSet() {
        return this.superClass != null;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public void setImports(List<String> imports) {
        this.imports = imports;
    }

    public boolean isImportsSet() {
        return this.imports != null && this.imports.size() > 0;
    }

    public String getUpdateListener() {
        return this.updateListener;
    }

    public void setUpdateListener(String updateListener) {
        this.updateListener = updateListener;
    }

    public boolean isUpdateListenerSet() {
        return this.updateListener != null;
    }

    protected void marshallAttributes(MithraGeneratorMarshaller marshaller) throws IOException {
        if (this.isInitializePrimitivesToNullSet()) {
            marshaller.writeAttribute("initializePrimitivesToNull", this.initializePrimitivesToNull);
        }
    }

    protected void marshallContent(MithraGeneratorMarshaller marshaller) throws IOException {
    }

    protected void marshallElements(MithraGeneratorMarshaller marshaller) throws IOException {
        if (this.isPackageNameSet()) {
            marshaller.writeSimpleTag("PackageName", this.packageName);
        }
        if (this.isClassNameSet()) {
            marshaller.writeSimpleTag("ClassName", this.className);
        }
        if (this.isSuperClassSet()) {
            this.superClass.toXml(marshaller, "SuperClass");
        }
        if (this.isImportsSet()) {
            for (String import_ : this.imports) {
                marshaller.writeSimpleTag("Import", import_);
            }
        }
        if (this.isUpdateListenerSet()) {
            marshaller.writeSimpleTag("UpdateListener", this.updateListener);
        }
    }

    public void toXml(MithraGeneratorMarshaller marshaller, String tagName) throws IOException {
        marshaller.writeStartTag(tagName);
        this.marshallAttributes(marshaller);
        this.marshallContent(marshaller);
        this.marshallElements(marshaller);
        marshaller.writeEndTag(tagName);
    }

    static {
        elementNameStates.put("PackageName", 1);
        elementNameStates.put("ClassName", 2);
        elementNameStates.put("SuperClass", 3);
        elementNameStates.put("Import", 4);
        elementNameStates.put("UpdateListener", 5);
    }
}

