/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.metamodel;

import com.gs.fw.common.mithra.generator.metamodel.Mithra;
import com.gs.fw.common.mithra.generator.metamodel.MithraEmbeddedValueObject;
import com.gs.fw.common.mithra.generator.metamodel.MithraGeneratorMarshaller;
import com.gs.fw.common.mithra.generator.metamodel.MithraInterface;
import com.gs.fw.common.mithra.generator.metamodel.MithraObject;
import com.gs.fw.common.mithra.generator.metamodel.MithraPureObject;
import com.gs.fw.common.mithra.generator.metamodel.MithraTempObject;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class MithraGeneratorMarshallerAbstract {
    private static ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private static ThreadLocal<SimpleDateFormat> dateTimeFormatWithZone = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
    };
    private EscapedAppendable appendable;
    private Closeable toCloseAtEnd;
    private int currentDepth;
    private int indentWidth = 4;
    private boolean tagIsOpen;
    private boolean indent;
    private boolean indentSafe;

    public void setIndentWidth(int width) {
        this.indentWidth = width;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    protected void setAppendable(Appendable appendable) {
        this.appendable = new EscapedAppendable(appendable);
    }

    protected void openFile(String filename) throws IOException {
        FileWriter writer = new FileWriter(filename);
        this.appendable = new EscapedAppendable(writer);
        this.toCloseAtEnd = writer;
    }

    protected void close() throws IOException {
        if (this.appendable != null) {
            this.appendable.flush();
        }
        this.appendable = null;
        this.currentDepth = 0;
        this.indentSafe = false;
        this.tagIsOpen = false;
        if (this.toCloseAtEnd != null) {
            this.toCloseAtEnd.close();
        }
    }

    private void cleanThreadLocals() {
        dateFormat.remove();
        dateTimeFormatWithZone.remove();
    }

    protected void toXml(Mithra mithra) throws IOException {
        try {
            mithra.toXml((MithraGeneratorMarshaller)this);
        }
        finally {
            this.cleanThreadLocals();
            this.close();
        }
    }

    public void marshall(String filename, Mithra mithra) throws IOException {
        this.openFile(filename);
        this.toXml(mithra);
    }

    public void marshall(OutputStream stream, Mithra mithra) throws IOException {
        this.appendable = new EscapedAppendable(new OutputStreamWriter(stream));
        this.toXml(mithra);
    }

    public void marshall(Appendable appendable, Mithra mithra) throws IOException {
        this.appendable = new EscapedAppendable(appendable);
        this.toXml(mithra);
    }

    protected void toXml(MithraObject mithraObject) throws IOException {
        try {
            mithraObject.toXml((MithraGeneratorMarshaller)this);
        }
        finally {
            this.cleanThreadLocals();
            this.close();
        }
    }

    public void marshall(String filename, MithraObject mithraObject) throws IOException {
        this.openFile(filename);
        this.toXml(mithraObject);
    }

    public void marshall(OutputStream stream, MithraObject mithraObject) throws IOException {
        this.appendable = new EscapedAppendable(new OutputStreamWriter(stream));
        this.toXml(mithraObject);
    }

    public void marshall(Appendable appendable, MithraObject mithraObject) throws IOException {
        this.appendable = new EscapedAppendable(appendable);
        this.toXml(mithraObject);
    }

    protected void toXml(MithraPureObject mithraPureObject) throws IOException {
        try {
            mithraPureObject.toXml((MithraGeneratorMarshaller)this);
        }
        finally {
            this.cleanThreadLocals();
            this.close();
        }
    }

    public void marshall(String filename, MithraPureObject mithraPureObject) throws IOException {
        this.openFile(filename);
        this.toXml(mithraPureObject);
    }

    public void marshall(OutputStream stream, MithraPureObject mithraPureObject) throws IOException {
        this.appendable = new EscapedAppendable(new OutputStreamWriter(stream));
        this.toXml(mithraPureObject);
    }

    public void marshall(Appendable appendable, MithraPureObject mithraPureObject) throws IOException {
        this.appendable = new EscapedAppendable(appendable);
        this.toXml(mithraPureObject);
    }

    protected void toXml(MithraTempObject mithraTempObject) throws IOException {
        try {
            mithraTempObject.toXml((MithraGeneratorMarshaller)this);
        }
        finally {
            this.cleanThreadLocals();
            this.close();
        }
    }

    public void marshall(String filename, MithraTempObject mithraTempObject) throws IOException {
        this.openFile(filename);
        this.toXml(mithraTempObject);
    }

    public void marshall(OutputStream stream, MithraTempObject mithraTempObject) throws IOException {
        this.appendable = new EscapedAppendable(new OutputStreamWriter(stream));
        this.toXml(mithraTempObject);
    }

    public void marshall(Appendable appendable, MithraTempObject mithraTempObject) throws IOException {
        this.appendable = new EscapedAppendable(appendable);
        this.toXml(mithraTempObject);
    }

    protected void toXml(MithraInterface mithraInterface) throws IOException {
        try {
            mithraInterface.toXml((MithraGeneratorMarshaller)this);
        }
        finally {
            this.cleanThreadLocals();
            this.close();
        }
    }

    public void marshall(String filename, MithraInterface mithraInterface) throws IOException {
        this.openFile(filename);
        this.toXml(mithraInterface);
    }

    public void marshall(OutputStream stream, MithraInterface mithraInterface) throws IOException {
        this.appendable = new EscapedAppendable(new OutputStreamWriter(stream));
        this.toXml(mithraInterface);
    }

    public void marshall(Appendable appendable, MithraInterface mithraInterface) throws IOException {
        this.appendable = new EscapedAppendable(appendable);
        this.toXml(mithraInterface);
    }

    protected void toXml(MithraEmbeddedValueObject mithraEmbeddedValueObject) throws IOException {
        try {
            mithraEmbeddedValueObject.toXml((MithraGeneratorMarshaller)this);
        }
        finally {
            this.cleanThreadLocals();
            this.close();
        }
    }

    public void marshall(String filename, MithraEmbeddedValueObject mithraEmbeddedValueObject) throws IOException {
        this.openFile(filename);
        this.toXml(mithraEmbeddedValueObject);
    }

    public void marshall(OutputStream stream, MithraEmbeddedValueObject mithraEmbeddedValueObject) throws IOException {
        this.appendable = new EscapedAppendable(new OutputStreamWriter(stream));
        this.toXml(mithraEmbeddedValueObject);
    }

    public void marshall(Appendable appendable, MithraEmbeddedValueObject mithraEmbeddedValueObject) throws IOException {
        this.appendable = new EscapedAppendable(appendable);
        this.toXml(mithraEmbeddedValueObject);
    }

    public void writeIndent(boolean startTag) throws IOException {
        if (this.indent && this.indentSafe) {
            if (this.currentDepth > 0 || !startTag) {
                this.appendable.rawAppend("\n");
            }
            for (int i = 0; i < this.currentDepth * this.indentWidth; ++i) {
                this.appendable.rawAppend(" ");
            }
        }
    }

    public void writeStartTag(String tagName) throws IOException {
        if (this.tagIsOpen) {
            this.appendable.rawAppend(">");
        }
        this.writeIndent(true);
        ++this.currentDepth;
        this.appendable.rawAppend("<").rawAppend(tagName);
        this.tagIsOpen = true;
        this.indentSafe = true;
    }

    public void writeDateAttribute(String tagName, Date date) throws IOException {
        this.writeAttribute(tagName, dateFormat.get().format(date));
    }

    public void writeDateTimeAttribute(String tagName, Date date) throws IOException {
        String formatted = dateTimeFormatWithZone.get().format(date);
        this.appendable.rawAppend(" ").rawAppend(tagName).rawAppend("=\"").rawAppend(formatted, 0, 26).rawAppend(":").rawAppend(formatted, 26, 28).rawAppend("\"");
    }

    public void writeDate(String tagName, Date date) throws IOException {
        this.writeSimpleTag(tagName, dateFormat.get().format(date));
    }

    public void writeDateTime(String tagName, Date date) throws IOException {
        this.writeStartTag(tagName);
        this.appendable.rawAppend(">");
        this.indentSafe = false;
        this.tagIsOpen = false;
        String formatted = dateTimeFormatWithZone.get().format(date);
        this.appendable.rawAppend(formatted, 0, 26).rawAppend(":").rawAppend(formatted, 26, 28);
        this.writeEndTag(tagName);
    }

    public void writeSimpleTag(String tagName, String value) throws IOException {
        this.writeStartTag(tagName);
        this.writeContent(value);
        this.writeEndTag(tagName);
    }

    public void writeSimpleTag(String tagName, boolean value) throws IOException {
        this.writeStartTag(tagName);
        this.writeContent(Boolean.toString(value));
        this.writeEndTag(tagName);
    }

    public void writeSimpleTag(String tagName, long value) throws IOException {
        this.writeStartTag(tagName);
        this.writeContent(Long.toString(value));
        this.writeEndTag(tagName);
    }

    public void writeSimpleTag(String tagName, int value) throws IOException {
        this.writeStartTag(tagName);
        this.writeContent(Integer.toString(value));
        this.writeEndTag(tagName);
    }

    public void writeSimpleTag(String tagName, double value) throws IOException {
        this.writeStartTag(tagName);
        this.writeContent(Double.toString(value));
        this.writeEndTag(tagName);
    }

    public void writeAttribute(String attributeName, String attributeValue) throws IOException {
        this.appendable.rawAppend(" ").rawAppend(attributeName).rawAppend("=\"").append(attributeValue).rawAppend("\"");
    }

    public void writeAttribute(String attributeName, boolean attributeValue) throws IOException {
        this.writeAttribute(attributeName, Boolean.toString(attributeValue));
    }

    public void writeAttribute(String attributeName, int attributeValue) throws IOException {
        this.writeAttribute(attributeName, Integer.toString(attributeValue));
    }

    public void writeAttribute(String attributeName, long attributeValue) throws IOException {
        this.writeAttribute(attributeName, Long.toString(attributeValue));
    }

    public void writeAttribute(String attributeName, double attributeValue) throws IOException {
        this.writeAttribute(attributeName, Double.toString(attributeValue));
    }

    public void writeEndTag(String tagName) throws IOException {
        --this.currentDepth;
        if (this.tagIsOpen) {
            this.appendable.rawAppend("/>");
        } else {
            this.writeIndent(false);
            this.appendable.rawAppend("</").rawAppend(tagName).rawAppend(">");
        }
        this.tagIsOpen = false;
        this.indentSafe = true;
    }

    public void writeContent(String content) throws IOException {
        this.indentSafe = false;
        this.tagIsOpen = false;
        this.appendable.rawAppend(">").appendDontEscapeLines(content);
    }

    private static class EscapedAppendable {
        private Appendable inner;

        private EscapedAppendable(Appendable inner) {
            this.inner = inner;
        }

        public EscapedAppendable append(char c) throws IOException {
            return this.append(c, true);
        }

        public EscapedAppendable append(char c, boolean escapeLines) throws IOException {
            if (c == '<') {
                this.inner.append("&lt;");
            } else if (c == '>') {
                this.inner.append("&gt;");
            } else if (c == '&') {
                this.inner.append("&amp;");
            } else if (c == '\'') {
                this.inner.append("&apos;");
            } else if (c == '\"') {
                this.inner.append("&quot;");
            } else if (c == '\t') {
                this.inner.append("&#x9;");
            } else if (c == '\n' && escapeLines) {
                this.inner.append("&#10;");
            } else if (c > '\u007f') {
                this.inner.append("&#").append(Integer.toString(c)).append(";");
            } else {
                this.inner.append(c);
            }
            return this;
        }

        public EscapedAppendable append(CharSequence csq) throws IOException {
            if (csq == null) {
                return this;
            }
            for (int i = 0; i < csq.length(); ++i) {
                this.append(csq.charAt(i), true);
            }
            return this;
        }

        public EscapedAppendable appendDontEscapeLines(CharSequence csq) throws IOException {
            if (csq == null) {
                return this;
            }
            for (int i = 0; i < csq.length(); ++i) {
                this.append(csq.charAt(i), false);
            }
            return this;
        }

        public EscapedAppendable append(CharSequence csq, int start, int end) throws IOException {
            for (int i = start; i < end; ++i) {
                this.append(csq.charAt(i), true);
            }
            return this;
        }

        public EscapedAppendable rawAppend(CharSequence csq) throws IOException {
            this.inner.append(csq);
            return this;
        }

        public EscapedAppendable rawAppend(CharSequence csq, int start, int end) throws IOException {
            this.inner.append(csq, start, end);
            return this;
        }

        public void flush() throws IOException {
            if (this.inner instanceof Flushable) {
                ((Flushable)((Object)this.inner)).flush();
            }
        }
    }
}

