/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.metamodel;

import com.gs.fw.common.mithra.generator.CommonWrapper;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.metamodel.AsOfAttributeInterfaceType;
import com.gs.fw.common.mithra.generator.metamodel.AttributeInterfaceType;
import com.gs.fw.common.mithra.generator.metamodel.MithraInterfaceTypeAbstract;
import com.gs.fw.common.mithra.generator.metamodel.RelationshipInterfaceType;
import com.gs.fw.common.mithra.generator.metamodel.SourceAttributeInterfaceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MithraInterfaceType
extends MithraInterfaceTypeAbstract
implements CommonWrapper {
    private String sourceFileName;
    private boolean readOnlyInterfaces = false;
    private String importedSource;
    private Set<MithraInterfaceType> allSuperInterfaces = new HashSet<MithraInterfaceType>();
    private Map<String, AttributeInterfaceType> allSuperAttributes = new HashMap<String, AttributeInterfaceType>();
    private Map<String, AsOfAttributeInterfaceType> allSuperAsOfAttributes = new HashMap<String, AsOfAttributeInterfaceType>();
    private Map<String, RelationshipInterfaceType> allSuperRelationships = new HashMap<String, RelationshipInterfaceType>();
    private Map<String, AttributeInterfaceType> declaredAttributes = new HashMap<String, AttributeInterfaceType>();
    private Map<String, AsOfAttributeInterfaceType> declaredAsOfAttributes = new HashMap<String, AsOfAttributeInterfaceType>();
    private Map<String, RelationshipInterfaceType> declaredRelationships = new HashMap<String, RelationshipInterfaceType>();

    public String getDescription() {
        return "mithra-interface";
    }

    public String getImplClassName() {
        return this.getClassName();
    }

    public String getAbstractClassName() {
        return this.getClassName() + "Abstract";
    }

    public List<String> extractRelationshipsAndSuperInterfaces(Map<String, MithraInterfaceType> mithraInterfaces, Map<String, MithraObjectTypeWrapper> mithraObjects) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (int i = 0; i < this.getRelationships().size(); ++i) {
            RelationshipInterfaceType relationshipType = this.getRelationships().get(i);
            relationshipType.resolveRelatedObject(mithraInterfaces, mithraObjects, errorMessages);
            this.addToRequiredClasses(relationshipType.getRelatedMithraObject().getPackageName(), relationshipType.getRelatedMithraObject().getClassName() + "Finder");
            this.addToRequiredClasses(relationshipType.getRelatedMithraObject().getPackageName(), relationshipType.getRelatedMithraObject().getClassName());
        }
        this.extractSuperInterfaces(mithraInterfaces, errorMessages);
        return errorMessages;
    }

    public void addToRequiredClasses(String packageName, String className) {
        if (!this.getPackageName().equals(packageName)) {
            this.getImports().add(packageName + "." + className);
        }
    }

    public void extractSuperInterfaces(Map<String, MithraInterfaceType> mithraInterfaces, List<String> errorMessages) {
        List<String> superInterfaces = this.getSuperInterfaces();
        for (int i = 0; i < superInterfaces.size(); ++i) {
            MithraInterfaceType superMithraInterface = mithraInterfaces.get(superInterfaces.get(i));
            HashSet<MithraInterfaceType> currentAllSuper = new HashSet<MithraInterfaceType>();
            ArrayList<String> errors = new ArrayList<String>();
            currentAllSuper.add(superMithraInterface);
            HashSet<MithraInterfaceType> allSuperCurrentInterface = this.processSuperInterfaces(mithraInterfaces, superMithraInterface, currentAllSuper, errors);
            if (errors.size() > 0) {
                errorMessages.addAll(errors);
                return;
            }
            this.allSuperInterfaces.addAll(allSuperCurrentInterface);
        }
        if (errorMessages.size() == 0) {
            this.initializeSuperInterfaceAttributesAndRelationships(errorMessages);
        }
    }

    public HashSet<MithraInterfaceType> processSuperInterfaces(Map<String, MithraInterfaceType> mithraInterfaces, MithraInterfaceType mithraInterfaceType, HashSet<MithraInterfaceType> accumulator, List<String> errorMessages) {
        if (errorMessages.size() == 0) {
            List<String> superInterfaces = mithraInterfaceType.getSuperInterfaces();
            for (int i = 0; i < superInterfaces.size(); ++i) {
                MithraInterfaceType superMithraInterface = mithraInterfaces.get(superInterfaces.get(i));
                if (accumulator.contains(superMithraInterface)) {
                    errorMessages.add("Circular dependency between SuperInterface : " + superMithraInterface.getClassName() + " and  " + this.getClassName());
                    break;
                }
                accumulator.add(superMithraInterface);
                this.processSuperInterfaces(mithraInterfaces, superMithraInterface, accumulator, errorMessages);
            }
        }
        return accumulator;
    }

    private void initializeSuperInterfaceAttributesAndRelationships(List<String> errorMessages) {
        for (MithraInterfaceType superInterface : this.allSuperInterfaces) {
            for (AttributeInterfaceType superInterfaceType : superInterface.getAttributes()) {
                AttributeInterfaceType localAttributeType = this.declaredAttributes.get(superInterfaceType.getName());
                if (localAttributeType == null || !localAttributeType.isCompatibleWithSuperAttribute(superInterfaceType, errorMessages)) continue;
                this.allSuperAttributes.put(superInterfaceType.getName(), superInterfaceType);
            }
            for (AsOfAttributeInterfaceType superAsOfAttribute : superInterface.getAsOfAttributes()) {
                AsOfAttributeInterfaceType localAsOfAttribute = this.declaredAsOfAttributes.get(superAsOfAttribute.getName());
                if (localAsOfAttribute == null || !localAsOfAttribute.isCompatibleWithSuperAsOfAttribute(superAsOfAttribute, errorMessages)) continue;
                this.allSuperAsOfAttributes.put(superAsOfAttribute.getName(), superAsOfAttribute);
            }
            SourceAttributeInterfaceType superSourceAttributeType = superInterface.getSourceAttribute();
            SourceAttributeInterfaceType localSourceAttributeType = this.getSourceAttribute();
            if (localSourceAttributeType != null && superSourceAttributeType != null) {
                localSourceAttributeType.isCompatibleWithSuperSourceAttribute(superSourceAttributeType, errorMessages);
            }
            for (RelationshipInterfaceType superRelationshipType : superInterface.getRelationships()) {
                RelationshipInterfaceType localRelationshipType = this.declaredRelationships.get(superRelationshipType.getName());
                if (localRelationshipType == null || !localRelationshipType.isCompatibleWithSuperRelationship(superRelationshipType, errorMessages)) continue;
                this.allSuperRelationships.put(superRelationshipType.getName(), superRelationshipType);
            }
        }
    }

    private void initializeAttributes() {
        for (AttributeInterfaceType attributeInterfaceType : this.getAttributes()) {
            this.declaredAttributes.put(attributeInterfaceType.getName(), attributeInterfaceType);
        }
        for (AsOfAttributeInterfaceType asOfAttributeInterfaceType : this.getAsOfAttributes()) {
            this.declaredAsOfAttributes.put(asOfAttributeInterfaceType.getName(), asOfAttributeInterfaceType);
        }
    }

    private void initializeRelationships() {
        for (RelationshipInterfaceType relationshipInterfaceType : this.getRelationships()) {
            this.declaredRelationships.put(relationshipInterfaceType.getName(), relationshipInterfaceType);
        }
    }

    public RelationshipInterfaceType[] getAllRelationships() {
        HashMap<String, RelationshipInterfaceType> allRelationships = new HashMap<String, RelationshipInterfaceType>();
        allRelationships.putAll(this.declaredRelationships);
        allRelationships.putAll(this.allSuperRelationships);
        RelationshipInterfaceType[] allRelationshipInterfaceType = new RelationshipInterfaceType[allRelationships.size()];
        return allRelationships.values().toArray(allRelationshipInterfaceType);
    }

    public AttributeInterfaceType[] getAllAttributes() {
        HashMap<String, AttributeInterfaceType> allAttributes = new HashMap<String, AttributeInterfaceType>();
        allAttributes.putAll(this.declaredAttributes);
        allAttributes.putAll(this.allSuperAttributes);
        AttributeInterfaceType[] allAttributeInterfaceType = new AttributeInterfaceType[allAttributes.size()];
        return allAttributes.values().toArray(allAttributeInterfaceType);
    }

    public AsOfAttributeInterfaceType[] getAllAsOfAttributes() {
        HashMap<String, AsOfAttributeInterfaceType> allAsOfAttributes = new HashMap<String, AsOfAttributeInterfaceType>();
        allAsOfAttributes.putAll(this.declaredAsOfAttributes);
        allAsOfAttributes.putAll(this.allSuperAsOfAttributes);
        AsOfAttributeInterfaceType[] allAsOfAttributeInterfaceType = new AsOfAttributeInterfaceType[allAsOfAttributes.size()];
        return allAsOfAttributes.values().toArray(allAsOfAttributeInterfaceType);
    }

    public AttributeInterfaceType[] getAttributesAsArray() {
        AttributeInterfaceType[] attributesArray = new AttributeInterfaceType[this.declaredAttributes.size()];
        return this.declaredAttributes.values().toArray(attributesArray);
    }

    public AsOfAttributeInterfaceType[] getAsOfAttributesAsArray() {
        AsOfAttributeInterfaceType[] attributes = new AsOfAttributeInterfaceType[this.getAsOfAttributes().size()];
        return this.getAsOfAttributes().toArray(attributes);
    }

    public boolean hasSuperInterface() {
        return this.allSuperInterfaces != null && this.allSuperInterfaces.size() > 0;
    }

    public Set<MithraInterfaceType> getAllSuperInterfaces() {
        return this.allSuperInterfaces;
    }

    public String getSuperInterfacesForAbstract() {
        StringBuilder result = new StringBuilder();
        for (String superInterface : this.getSuperInterfaces()) {
            result.append(superInterface);
            result.append(", ");
        }
        String returnsStr = result.toString();
        int index = returnsStr.lastIndexOf(", ");
        if (index != -1) {
            returnsStr = result.substring(0, index);
        }
        return returnsStr;
    }

    public String getSuperInterfacesForFinder() {
        StringBuilder result = new StringBuilder();
        for (String superInterface : this.getSuperInterfaces()) {
            result.append(superInterface).append("Finder<Result>");
            result.append(", ");
        }
        String returnsStr = result.toString();
        int index = returnsStr.lastIndexOf(", ");
        if (index != -1) {
            returnsStr = result.substring(0, index);
        }
        return returnsStr;
    }

    public RelationshipInterfaceType[] getRelationshipsAsArray() {
        RelationshipInterfaceType[] relationships = new RelationshipInterfaceType[this.getRelationships().size()];
        return this.getRelationships().toArray(relationships);
    }

    public boolean hasSourceAttribute() {
        return this.getSourceAttribute() != null;
    }

    public void setSourceFileName(String sourceFile) {
        this.sourceFileName = sourceFile;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void postInitialize(String objectName) {
        this.setSourceFileName(objectName);
        this.initializeAttributes();
        this.initializeRelationships();
    }

    public void setReadOnlyInterfaces(boolean readOnlyInterfaces) {
        this.readOnlyInterfaces = readOnlyInterfaces;
    }

    public boolean isReadOnlyInterfaces() {
        return this.readOnlyInterfaces;
    }

    public void setImportedSource(String importedSource) {
        this.importedSource = importedSource;
    }

    public boolean isImported() {
        return this.importedSource != null;
    }
}

